"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ToolbarButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _toolbarButton = _interopRequireDefault(require("./toolbar-button.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const ToolbarButton = exports.ToolbarButton = /*#__PURE__*/_react.default.forwardRef(({
  onKeyDown,
  onMouseDown,
  activated,
  ariaLabel,
  tabbable,
  children,
  onMouseOver,
  onMouseLeave,
  onFocus,
  onBlur
}, ref) => {
  return /*#__PURE__*/_react.default.createElement(_toolbarButton.default, _extends({
    "data-component": "text-editor-toolbar-button",
    ref: ref,
    onKeyDown: onKeyDown,
    onMouseDown: onMouseDown,
    isActive: activated,
    "aria-label": ariaLabel
  }, !tabbable && {
    tabIndex: -1
  }, {
    onMouseOver: onMouseOver,
    onMouseLeave: onMouseLeave,
    onFocus: onFocus,
    onBlur: onBlur
  }), children);
});
if (process.env.NODE_ENV !== "production") {
  ToolbarButton.propTypes = {
    "activated": _propTypes.default.bool,
    "ariaLabel": _propTypes.default.string.isRequired,
    "children": _propTypes.default.node,
    "onBlur": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func.isRequired,
    "onMouseDown": _propTypes.default.func.isRequired,
    "onMouseLeave": _propTypes.default.func,
    "onMouseOver": _propTypes.default.func,
    "tabbable": _propTypes.default.bool
  };
}
ToolbarButton.displayName = "ToolbarButton";
var _default = exports.default = ToolbarButton;