"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _editorLink = _interopRequireDefault(require("./editor-link.style"));
var _textEditor = require("../../text-editor.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const EditorLink = ({
  children,
  contentState,
  entityKey,
  ...rest
}) => {
  const url = !!contentState && !!entityKey ? contentState.getEntity(entityKey).getData() : children[0].props.text;
  const buildValidUrl = () => {
    const candidateUrl = url.url || url;
    const regex = /(http:\/\/|https:\/\/)+/g;
    return regex.test(candidateUrl) ? candidateUrl : `https://${candidateUrl}`;
  };
  const validUrl = buildValidUrl();
  const {
    onLinkAdded,
    editMode
  } = (0, _react.useContext)(_textEditor.EditorContext);
  (0, _react.useEffect)(() => {
    if (onLinkAdded) {
      onLinkAdded(validUrl);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [validUrl]);
  return /*#__PURE__*/_react.default.createElement(_editorLink.default, _extends({
    href: !editMode ? validUrl : undefined,
    "aria-label": !editMode ? validUrl : undefined,
    target: "_blank",
    rel: "noopener noreferrer"
  }, rest), children);
};
var _default = exports.default = EditorLink;