"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TabContext = exports.Tab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tab = _interopRequireDefault(require("./tab.style"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TabContext = exports.TabContext = /*#__PURE__*/_react.default.createContext({});
const Tab = ({
  ariaLabelledby,
  className,
  children,
  isTabSelected,
  position = "top",
  role = "tabpanel",
  tabId,
  updateErrors,
  updateWarnings,
  updateInfos,
  href,
  // title is destructured purely to NOT spread it as part of rest to the underlying HTML element.
  // Both this and titleProps are used as part of child.props inside Tabs component
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  title,
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  titleProps,
  ...rest
}) => {
  const [tabErrors, setTabErrors] = (0, _react.useState)({});
  const [tabWarnings, setTabWarnings] = (0, _react.useState)({});
  const [tabInfos, setTabInfos] = (0, _react.useState)({});
  const setError = (0, _react.useCallback)((childId, error) => {
    setTabErrors(state => state[childId] !== error ? {
      ...state,
      [childId]: error
    } : state);
  }, []);
  const setWarning = (0, _react.useCallback)((childId, warning) => {
    setTabWarnings(state => state[childId] !== warning ? {
      ...state,
      [childId]: warning
    } : state);
  }, []);
  const setInfo = (0, _react.useCallback)((childId, info) => {
    setTabInfos(state => state[childId] !== info ? {
      ...state,
      [childId]: info
    } : state);
  }, []);
  (0, _react.useEffect)(() => {
    if (updateErrors) {
      updateErrors(tabId, tabErrors);
    }
  }, [tabId, tabErrors, updateErrors]);
  (0, _react.useEffect)(() => {
    if (updateWarnings) {
      updateWarnings(tabId, tabWarnings);
    }
  }, [tabId, tabWarnings, updateWarnings]);
  (0, _react.useEffect)(() => {
    if (updateInfos) {
      updateInfos(tabId, tabInfos);
    }
  }, [tabId, tabInfos, updateInfos]);
  return /*#__PURE__*/_react.default.createElement(TabContext.Provider, {
    value: {
      setError,
      setWarning,
      setInfo
    }
  }, /*#__PURE__*/_react.default.createElement(_tab.default, _extends({
    className: className,
    role: role,
    isTabSelected: isTabSelected,
    "aria-labelledby": ariaLabelledby,
    position: position
  }, (0, _tags.default)("tab", rest), rest), !href && children));
};
exports.Tab = Tab;
var _default = exports.default = Tab;