"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledVerticalTabsWrapper = exports.StyledTabsWrapper = exports.StyledTabsHeaderWrapper = exports.StyledTabsHeaderList = exports.StyledTabsBottomBorderWrapper = exports.StyledTabsBottomBorder = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const outlineWidth = "3px";
const StyledTabsHeaderWrapper = exports.StyledTabsHeaderWrapper = _styledComponents.default.div`
  ${({
  position,
  isInSidebar
}) => position === "left" && (0, _styledComponents.css)`
      box-sizing: border-box;
      padding: 3px;

      button[data-element="select-tab"] {
        border-top-left-radius: var(--borderRadius100);
        border-bottom-left-radius: var(--borderRadius100);
      }

      ${!isInSidebar && (0, _styledComponents.css)`
        min-width: 20%;
        overflow-y: auto;
      `}

      ${isInSidebar && (0, _styledComponents.css)`
        min-width: 100%;
        margin: auto;
        padding: 0px;
      `}
    `}
`;
const commonShadowStyles = (0, _styledComponents.css)`
  pointer-events: none;
  content: "";
  background-repeat: no-repeat;
  background-size: 16px 48px;
  background-attachment: scroll;
  z-index: ${({
  theme
}) => theme.zIndex.overlay};
  position: sticky;
  min-width: 16px;
  transition: opacity 0.1s ease-in-out;
`;
const StyledTabsHeaderList = exports.StyledTabsHeaderList = _styledComponents.default.div`
  display: flex;
  ${({
  extendedLine = true
}) => !extendedLine && (0, _styledComponents.css)`
      width: fit-content;
    `}
  cursor: default;
  list-style: none;
  padding: ${outlineWidth};
  overflow-x: auto;
  position: relative;
  ${({
  position
}) => position === "top" && "white-space: nowrap"};

  ${({
  isScrollable,
  leftScrollOpacity,
  rightScrollOpacity
}) => isScrollable && (0, _styledComponents.css)`
      &:before {
        ${commonShadowStyles}
        background: radial-gradient(
          farthest-side at 0 50%,
          rgba(0, 0, 0, 0.2),
          rgba(0, 0, 0, 0)
        );
        background-position: left calc(50% - 4px);
        left: -${outlineWidth};
        margin-right: -16px;
        opacity: ${leftScrollOpacity};
      }

      &:after {
        ${commonShadowStyles}
        background: radial-gradient(
          farthest-side at 100% 50%,
          rgba(0, 0, 0, 0.2),
          rgba(0, 0, 0, 0)
        );
        background-position: right calc(50% - 4px);
        right: -${outlineWidth};
        margin-left: -16px;
        opacity: ${rightScrollOpacity};
      }
    `}

  &::-webkit-scrollbar {
    -webkit-appearance: none;
    background: var(--colorsUtilityMajor025);
    height: 8px;
    width: 8px;
  }

  &::-webkit-scrollbar-thumb {
    background-color: var(--colorsUtilityMajor300);
    cursor: pointer;
  }

  ${({
  align = "left"
}) => align === "right" && (0, _styledComponents.css)`
      justify-content: flex-end;
      text-align: right;
    `}

  ${({
  position = "top",
  noRightBorder,
  align = "left"
}) => position === "left" && (0, _styledComponents.css)`
      flex-direction: column;
      box-shadow: none;

      ${noRightBorder && (0, _styledComponents.css)`
        box-shadow: none;
      `}

      ${align === "right" && (0, _styledComponents.css)`
        justify-content: flex-start;
      `}
    `}
`;
StyledTabsHeaderList.defaultProps = {
  theme: _base.default
};
const StyledTabsWrapper = exports.StyledTabsWrapper = _styledComponents.default.div`
  margin: 3px;
  position: relative;
  min-width: max-content;
  width: 100%;
  height: 100%;
`;
const StyledVerticalTabsWrapper = exports.StyledVerticalTabsWrapper = _styledComponents.default.div`
  margin: 3px;
  ${({
  isInSidebar
}) => isInSidebar && (0, _styledComponents.css)`
      margin-left: 6px;
      margin-top: 6px;
    `}
  display: flex;
  flex-direction: column;
`;
const StyledTabsBottomBorderWrapper = exports.StyledTabsBottomBorderWrapper = _styledComponents.default.div`
  position: absolute;
  width: 100%;
  height: auto;
  bottom: 0;
`;
const StyledTabsBottomBorder = exports.StyledTabsBottomBorder = _styledComponents.default.div`
  position: sticky;
  bottom: 2px;
  left: ${outlineWidth};
  right: ${outlineWidth};
  height: 2px;
  background-color: var(--colorsActionMinor100);
`;