"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tabsHeader = require("./tabs-header.style");
var _useThrottle = _interopRequireDefault(require("../../../../hooks/__internal__/useThrottle"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*  In the original prototype the tabs have shadows that fade out as you scroll horizontally.
 *  This value is the closest replication to the way that the shadow disappears.
 *  It is ultimately tied to the position of the scroll that will then fade the shadow in and out. */
const fullOpacityThreshold = 128;
const getOpacityRatio = value => value / fullOpacityThreshold;
const getScrollRight = ({
  scrollWidth,
  clientWidth,
  scrollLeft
}) => scrollWidth - clientWidth - scrollLeft;
const TabsHeader = ({
  align = "left",
  children,
  position = "top",
  role,
  extendedLine,
  noRightBorder = false,
  isInSidebar = false
}) => {
  const [leftScrollOpacity, setLeftScrollOpacity] = (0, _react.useState)(0);
  const [rightScrollOpacity, setRightScrollOpacity] = (0, _react.useState)(1);
  const ref = (0, _react.useRef)(null);
  let isScrollable = false;
  const {
    current
  } = ref;
  if (position === "top" && current) {
    isScrollable = current.scrollWidth > current.clientWidth;
  }
  const handleScroll = e => {
    const {
      scrollLeft
    } = e.target;
    const scrollRight = getScrollRight(e.target);
    setLeftScrollOpacity(Math.min(getOpacityRatio(scrollLeft), 1));
    setRightScrollOpacity(Math.min(getOpacityRatio(scrollRight), 1));
  };
  const throttledHandleScroll = (0, _useThrottle.default)(handleScroll, 50);
  return /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledTabsHeaderWrapper, {
    isInSidebar: isInSidebar,
    position: position
  }, /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledTabsHeaderList, {
    align: align,
    position: position,
    role: role,
    extendedLine: extendedLine,
    noRightBorder: noRightBorder,
    isInSidebar: isInSidebar,
    onScroll: throttledHandleScroll,
    leftScrollOpacity: leftScrollOpacity,
    rightScrollOpacity: rightScrollOpacity,
    isScrollable: isScrollable,
    ref: ref
  }, position === "top" ? /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledTabsWrapper, null, /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledTabsBottomBorderWrapper, null, /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledTabsBottomBorder, null)), children) : /*#__PURE__*/_react.default.createElement(_tabsHeader.StyledVerticalTabsWrapper, {
    isInSidebar: isInSidebar
  }, children)));
};
var _default = exports.default = TabsHeader;