"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTitleContent = exports.StyledTabTitleLink = exports.StyledTabTitleButton = exports.StyledSelectedIndicator = exports.StyledLayoutWrapper = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../../../icon/icon.style"));
var _validationIcon = _interopRequireDefault(require("../../../../__internal__/validations/validation-icon.style"));
var _addFocusStyling = _interopRequireDefault(require("../../../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledTitleContent = exports.StyledTitleContent = _styledComponents.default.span`
  outline: none;
  display: inline-block;
  line-height: 20px;
  margin: 0;
  position: relative;

  ${({
  hasCustomLayout,
  error,
  warning,
  info,
  size,
  isTabSelected,
  hasSiblings,
  borders = false,
  position = "top",
  noLeftBorder,
  noRightBorder,
  hasHref,
  alternateStyling,
  align
}) => (0, _styledComponents.css)`
    text-align: ${align};

    ${position === "left" && (0, _styledComponents.css)`
      display: flex;
      width: 100%;
      justify-content: ${align === "right" ? "flex-end" : "flex-start"};
      border-top-left-radius: var(--borderRadius100);
      border-bottom-left-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius000);
      border-top-right-radius: var(--borderRadius000);
    `}

    ${position === "top" && (0, _styledComponents.css)`
      border-top-left-radius: var(--borderRadius100);
      border-top-right-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius000);
      border-bottom-left-radius: var(--borderRadius000);
    `}

    ${hasHref && (0, _styledComponents.css)`
      color: var(--colorsActionMinorYin090);
      display: block;
      text-decoration: none;

      [type="link"] {
        width: 16px;
        margin-left: 8px;
        height: 16px;
        color: inherit;
        margin-top: -2px;
      }
    `}

    ${!hasHref && (0, _styledComponents.css)`
      [data-component="icon"]:not([color]) {
        color: var(--colorsActionMinorYin065);
      }
    `}

    ${borders && (0, _styledComponents.css)`
      border-top: 1px solid var(--colorsActionMinor100);
      border-left: 1px solid var(--colorsActionMinor100);
      border-right: 1px solid var(--colorsActionMinor100);

      ${position === "left" && (0, _styledComponents.css)`
        border-bottom: 1px solid var(--colorsActionMinor100);
        ${!alternateStyling && `margin-right: -1px;`}
      `}

      ${noLeftBorder && (0, _styledComponents.css)`
        border-left: none;

        ${!noRightBorder && (0, _styledComponents.css)`
          border-right: 1px solid var(--colorsActionMinor100);
        `}
      `}

      ${noRightBorder && (0, _styledComponents.css)`
        border-right: none;
      `}
    `}

    ${size === "large" && position === "top" && (0, _styledComponents.css)`
      padding: 14px 24px;
      ${borders && `padding-bottom: 9px;`}
      font-size: 16px;
    `}

    ${size === "large" && position === "left" && (0, _styledComponents.css)`
      font-size: 16px;
      padding: 14px 24px;
    `}

    ${size === "default" && (0, _styledComponents.css)`
      padding: 10px 16px;

      ${borders && `padding-bottom: 9px;`}
    `} 

    ${(warning || info) && (0, _styledComponents.css)`
      outline: 1px solid;
      outline-offset: -1px;
      z-index: 2;

      ${info && !warning && (0, _styledComponents.css)`
        outline-color: var(--colorsSemanticInfo500);
      `}

      ${warning && (0, _styledComponents.css)`
        outline-color: var(--colorsSemanticCaution500);
      `}

      ${position === "top" && (0, _styledComponents.css)`
        border-bottom-color: transparent;
      `}

      ${position === "left" && (0, _styledComponents.css)`
        border-right-color: transparent;
        padding-right: ${size === "large" ? "26px" : "18px"};
      `}
      
      &:hover {
        outline: 1px solid;
        outline-offset: -1px;

        ${info && !warning && (0, _styledComponents.css)`
          outline-color: var(--colorsSemanticInfo500);
        `}

        ${warning && (0, _styledComponents.css)`
          outline-color: var(--colorsSemanticCaution500);
        `}

        ${position === "top" && (0, _styledComponents.css)`
          border-bottom-color: transparent;

          ${hasCustomLayout && (0, _styledComponents.css)`
            padding-bottom: 2px;
          `}
        `}

        ${position === "left" && (0, _styledComponents.css)`
          border-right-color: transparent;
          padding-right: ${size === "large" ? "26px" : "18px"};
        `}
      }
    `}

    ${error && (0, _styledComponents.css)`
      outline: 2px solid var(--colorsSemanticNegative500);
      outline-offset: -2px;
      z-index: 2;

      ${position === "top" && (0, _styledComponents.css)`
        border-bottom-color: transparent;
      `}

      ${position === "left" && (0, _styledComponents.css)`
        border-right-color: transparent;
        padding-right: ${size === "large" ? "26px" : "18px"};
      `}
    
      &:hover {
        outline: 2px solid var(--colorsSemanticNegative500);
        outline-offset: -2px;
        ${position === "top" && (0, _styledComponents.css)`
          border-bottom-color: transparent;

          ${hasCustomLayout && (0, _styledComponents.css)`
            padding-bottom: 2px;
          `}
        `}

        ${position === "left" && (0, _styledComponents.css)`
          border-right-color: transparent;
          padding-right: ${size === "large" ? "26px" : "18px"};
        `}
      }
    `}

    ${hasSiblings && !hasCustomLayout && position === "top" && (0, _styledComponents.css)`
      height: 20px;
    `}

    ${hasCustomLayout && (0, _styledComponents.css)`
      display: flex;

      ${position === "left" && (0, _styledComponents.css)`
        padding: ${size === "large" ? "2px" : "0px"};
        ${isTabSelected && (0, _styledComponents.css)`
          padding-right: 0px;
        `}
        ${(error || warning || info) && (0, _styledComponents.css)`
          padding-right: ${size === "large" ? "26px" : "18px"};
        `}
      `}

      ${position === "top" && (0, _styledComponents.css)`
        padding: ${size === "large" ? "2px" : "0px"};
        ${isTabSelected && (0, _styledComponents.css)`
          padding-bottom: 0px;
        `}
        ${(error || warning || info) && (0, _styledComponents.css)`
          padding-bottom: ${size === "large" ? "4px" : "2px"};
          padding-right: ${size === "large" ? "18px" : "14px"};

          &:hover {
            padding-bottom: ${size === "large" ? "4px" : "2px"};
          }
        `}
      `}
    `}
  `}
`;
const tabTitleStyles = (0, _styledComponents.css)`
  background-color: transparent;
  display: inline-block;
  border-top-left-radius: var(--borderRadius100);
  border-top-right-radius: var(--borderRadius100);
  font-weight: bold;
  position: relative;
  border: none;
  cursor: pointer;
  font-size: 14px;
  padding: 0px;
  text-decoration: none;
  outline-offset: 0px;
  margin: 0;
  ${({
  position
}) => position === "top" && "white-space: nowrap"};

  ${({
  position
}) => (0, _styledComponents.css)`
    ${position === "left" && (0, _styledComponents.css)`
      border-top-right-radius: var(--borderRadius000);
    `}
  `}

  a:visited {
    color: inherit;
  }

  ${({
  size,
  position = "top",
  borders = false,
  noRightBorder,
  noLeftBorder,
  isTabSelected,
  alternateStyling,
  error,
  warning,
  info,
  isInSidebar
}) => (0, _styledComponents.css)`
    height: ${size === "large" ? "var(--sizing600)" : "var(--sizing500)"};

    ${position === "top" && (0, _styledComponents.css)`
      ${borders && !(noRightBorder || noLeftBorder) && (0, _styledComponents.css)`
        &:nth-of-type(n + 1):not(:first-of-type) {
          margin-left: -1px;
        }
        &:first-child {
          margin-left: 0;
        }
      `}
    `}
    ${position === "left" && (0, _styledComponents.css)`
      ${borders && (0, _styledComponents.css)`
        &:nth-of-type(n + 1):not(:first-of-type) {
          margin-top: -1px;
        }
        &:first-child {
          margin-top: 0;
        }
      `}
    `}

    ${!isTabSelected && (0, _styledComponents.css)`
      color: var(--colorsActionMinorYin090);

      &:hover {
        background: var(--colorsActionMinor100);
        color: var(--colorsActionMinorYin090);
        outline: none;
      }
      &:focus {
        color: var(--colorsActionMinorYin090);
        outline: none;
      }
    `}

    ${isTabSelected && (0, _styledComponents.css)`
      color: var(--colorsActionMajorYin090);
      background-color: var(--colorsActionMajorYang100);

      ${(error || warning || info) && (0, _styledComponents.css)`
        padding-bottom: 0px;
      `}

      &:hover {
        background-color: var(--colorsActionMajorYang100);
        border-bottom-color: ${alternateStyling ? "var(--colorsActionMinor100)" : "var(--colorsActionMajor500)"};
        color: var(--colorsActionMajorYin090);
        cursor: default;
      }
    `}

    &:focus {
      ${({
  theme
}) => `${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}`}
      z-index: 3;

      ${isInSidebar && (0, _styledComponents.css)`
        outline-offset: -3px;
      `}
    }

    ${position === "left" && (0, _styledComponents.css)`
      background-color: transparent;
      border-bottom: 0px;

      ${!isInSidebar && !error && (0, _styledComponents.css)`
        border-right: ${alternateStyling ? "1px" : "2px"} solid
          var(--colorsActionMinor100);
      `}

      ${!borders && (0, _styledComponents.css)`
        ${StyledTitleContent} {
          border-bottom: none;
        }
      `}

      display: flex;
      height: auto;
      margin-left: 0px;

      &:first-child {
        margin-top: 0;
      }

      &:hover {
        ${alternateStyling && "border-right-color: var(--colorsActionMinor100)"}
      }

      ${(warning || info) && (0, _styledComponents.css)`
        border-right: none;
      `}

      ${isTabSelected && (0, _styledComponents.css)`
        ${alternateStyling && (0, _styledComponents.css)`
          border-right-color: var(--colorsActionMinor100);
        `}

        ${!alternateStyling && (0, _styledComponents.css)`
          border-right: none;
          padding-bottom: 0px;

          ${StyledTitleContent} {
            ${!(error || warning || info) && "margin-right: 2px;"}
            border-right: none;
          }
        `}
  
        background-color: var(--colorsActionMajorYang100);

        &:hover {
          ${alternateStyling && "border-right-color: var(--colorsActionMinor100);"}
          background-color: var(--colorsActionMajorYang100);
          ${(error || warning || info) && "border-right-color: var(--colorsSemanticNegative500);"}
        }

        &:focus {
          ${(error || warning || info) && "border-right-color: var(--colorsSemanticNegative500);"}
        }
      `}
    `}

    ${alternateStyling && (0, _styledComponents.css)`
      &:focus {
        background-color: var(--colorsActionMinor200);
      }

      &:hover {
        background-color: ${isTabSelected ? "var(--colorsActionMinor200)" : "var(--colorsActionMinor250)"};
      }

      ${isTabSelected && (0, _styledComponents.css)`
        background-color: var(--colorsActionMinor200);
      `}
    `}
  `}
`;
const StyledTabTitleButton = exports.StyledTabTitleButton = _styledComponents.default.button`
  ${tabTitleStyles}
`;
const StyledTabTitleLink = exports.StyledTabTitleLink = _styledComponents.default.a`
  ${tabTitleStyles}
`;
const StyledLayoutWrapper = exports.StyledLayoutWrapper = _styledComponents.default.div`
  ${({
  hasCustomLayout,
  titlePosition = "before",
  hasCustomSibling,
  position
}) => (0, _styledComponents.css)`
    ${hasCustomLayout && (0, _styledComponents.css)`
      flex-grow: 2;
    `}

    ${!hasCustomLayout && (0, _styledComponents.css)`
      display: inline-flex;

      position: relative;
      top: -1px;
      ${hasCustomSibling && (0, _styledComponents.css)`
        left: 4px;
      `}
      ${!hasCustomSibling && (0, _styledComponents.css)`
        ${titlePosition === "before" ? "left: 8px;" : "right: 8px;"}
      `}

      ${_icon.default} {
        height: 20px;
      }

      ${_validationIcon.default} {
        z-index: 10;

        ${_icon.default} {
          height: 16px;
          left: -2px;
          top: ${position === "left" ? "1px" : "3px"};
        }
      }
    `}
  `}
`;
const StyledSelectedIndicator = exports.StyledSelectedIndicator = _styledComponents.default.div`
  position: absolute;
  z-index: 1;

  ${({
  position = "top"
}) => (0, _styledComponents.css)`
    ${position === "top" && (0, _styledComponents.css)`
      bottom: 0px;
      left: 0px;
      right: 0px;
      box-shadow: inset 0px calc(-1 * var(--sizing050)) 0px
        var(--colorsActionMajor500);
      height: var(--sizing050);
    `}

    ${position === "left" && (0, _styledComponents.css)`
      top: 0px;
      bottom: 0px;
      right: 0px;
      box-shadow: inset calc(-1 * var(--sizing050)) 0px 0px 0px
        var(--colorsActionMajor500);
      width: var(--sizing050);
    `}
  `}
`;