"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TabTitleContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tabTitle = require("./tab-title.style");
var _tags = _interopRequireDefault(require("../../../../__internal__/utils/helpers/tags/tags"));
var _validationIcon = _interopRequireDefault(require("../../../../__internal__/validations/validation-icon.component"));
var _icon = _interopRequireDefault(require("../../../icon"));
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _tooltipProvider = require("../../../../__internal__/tooltip-provider");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TabTitleContext = exports.TabTitleContext = /*#__PURE__*/_react.default.createContext({});
const TabTitle = /*#__PURE__*/_react.default.forwardRef(({
  isTabSelected,
  dataTabId,
  "data-role": dataRole,
  title,
  position,
  error,
  warning,
  info,
  size = "default",
  onClick,
  titlePosition = "before",
  siblings,
  errorMessage = "",
  warningMessage = "",
  infoMessage = "",
  borders,
  alternateStyling = false,
  noLeftBorder = false,
  noRightBorder = false,
  customLayout,
  isInSidebar,
  href,
  onKeyDown,
  align,
  tabIndex,
  ...tabTitleProps
}, ref) => {
  const isHref = !!href;
  const hasAlternateStyling = alternateStyling || isInSidebar;
  const hasFailedValidation = error || warning || info;
  const [shouldShowTooltip, setShouldShowTooltip] = (0, _react.useState)(false);
  const hasHover = (0, _react.useRef)(false);
  const showTooltip = () => {
    setShouldShowTooltip(true);
  };
  const hideTooltip = () => {
    if (typeof ref === "object" && ref?.current !== document.activeElement && !hasHover.current) {
      setShouldShowTooltip(false);
    }
  };
  const handleKeyDown = ev => {
    ev.stopPropagation();
    if (href && _events.default.isEnterOrSpaceKey(ev)) {
      return window.open(href, "_blank");
    }
    return onKeyDown(ev);
  };
  const handleClick = ev => {
    ev.preventDefault();
    const customEvent = {
      ...ev,
      target: {
        ...ev.target,
        dataset: {
          tabid: dataTabId
        }
      }
    };
    if (href) {
      onClick(customEvent);
      return window.open(href, "_blank");
    }

    // safari does not focus buttons by default
    // istanbul ignore else (ref is always passed as an object from Tabs component, if was only added to satisfy Typescript compiler)
    if (typeof ref === "object") {
      ref?.current?.focus();
    }
    return onClick(customEvent);
  };
  const renderContent = () => {
    if (customLayout) {
      return /*#__PURE__*/_react.default.createElement(_tabTitle.StyledLayoutWrapper, {
        hasCustomLayout: true
      }, customLayout);
    }
    if (!siblings) {
      return title;
    }
    const titleText = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: "title"
    }, title);
    const titleSiblings = /*#__PURE__*/_react.default.createElement(_tabTitle.StyledLayoutWrapper, {
      titlePosition: titlePosition,
      key: "title-siblings"
    }, _react.default.Children.toArray(siblings).map(child => {
      // istanbul ignore next
      if (! /*#__PURE__*/_react.default.isValidElement(child)) {
        return child;
      }
      return /*#__PURE__*/_react.default.cloneElement(child, {
        ...child.props,
        onClick: handleClick
      });
    }));
    return titlePosition === "before" ? [titleText, titleSiblings] : [titleSiblings, titleText];
  };
  const titleChildren = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tabTitle.StyledTitleContent, {
    error: error,
    warning: warning,
    info: info,
    position: position,
    size: size,
    noLeftBorder: noLeftBorder,
    noRightBorder: noRightBorder,
    borders: borders,
    hasSiblings: !!siblings,
    isTabSelected: isTabSelected,
    hasCustomLayout: !!customLayout,
    alternateStyling: hasAlternateStyling,
    align: align,
    hasHref: !!href
  }, renderContent(), isHref && /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "link"
  }), hasFailedValidation && /*#__PURE__*/_react.default.createElement(_tabTitle.StyledLayoutWrapper, {
    position: position,
    hasCustomSibling: !!customLayout
  }, error && /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
    tooltipPosition: "top",
    error: errorMessage
  }), !error && warning && /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
    tooltipPosition: "top",
    warning: warningMessage
  }), !warning && !error && info && /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
    tooltipPosition: "top",
    info: infoMessage
  }))), !(hasFailedValidation || hasAlternateStyling) && isTabSelected && /*#__PURE__*/_react.default.createElement(_tabTitle.StyledSelectedIndicator, {
    "data-element": "tab-selected-indicator",
    position: position
  }));
  const titleWrapperProps = {
    "aria-selected": isTabSelected,
    "data-element": "select-tab",
    "data-tabid": dataTabId,
    "data-role": dataRole,
    role: "tab",
    position,
    isTabSelected,
    error,
    warning,
    info,
    noRightBorder,
    noLeftBorder,
    alternateStyling: alternateStyling || isInSidebar,
    borders,
    isInSidebar,
    tabIndex,
    ...tabTitleProps,
    ...(0, _tags.default)("tab-header", tabTitleProps),
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    size,
    onMouseOver: () => {
      hasHover.current = true;
      showTooltip();
    },
    onMouseLeave: () => {
      hasHover.current = false;
      hideTooltip();
    },
    onFocus: showTooltip,
    onBlur: hideTooltip
  };
  const tabTitle = isHref ? /*#__PURE__*/_react.default.createElement(_tabTitle.StyledTabTitleLink, _extends({}, titleWrapperProps, {
    ref: ref,
    href: href,
    target: "_blank"
  }), titleChildren) : /*#__PURE__*/_react.default.createElement(_tabTitle.StyledTabTitleButton, _extends({}, titleWrapperProps, {
    type: "button",
    ref: ref
  }), titleChildren);
  return /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    tooltipVisible: shouldShowTooltip
  }, /*#__PURE__*/_react.default.createElement(TabTitleContext.Provider, {
    value: {
      isInTab: true
    }
  }, tabTitle));
});
if (process.env.NODE_ENV !== "production") {
  TabTitle.propTypes = {
    "align": _propTypes.default.oneOf(["left", "right"]),
    "alternateStyling": _propTypes.default.bool,
    "borders": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "customLayout": _propTypes.default.node,
    "data-role": _propTypes.default.string,
    "dataTabId": _propTypes.default.string,
    "error": _propTypes.default.bool,
    "errorMessage": _propTypes.default.string,
    "href": _propTypes.default.string,
    "id": _propTypes.default.string,
    "info": _propTypes.default.bool,
    "infoMessage": _propTypes.default.string,
    "isInSidebar": _propTypes.default.bool,
    "isTabSelected": _propTypes.default.bool,
    "noLeftBorder": _propTypes.default.bool,
    "noRightBorder": _propTypes.default.bool,
    "onClick": _propTypes.default.func.isRequired,
    "onKeyDown": _propTypes.default.func.isRequired,
    "position": _propTypes.default.oneOf(["left", "top"]),
    "siblings": _propTypes.default.node,
    "size": _propTypes.default.oneOf(["default", "large"]),
    "tabIndex": _propTypes.default.number,
    "title": _propTypes.default.string,
    "titlePosition": _propTypes.default.oneOf(["after", "before"]),
    "warning": _propTypes.default.bool,
    "warningMessage": _propTypes.default.string
  };
}
TabTitle.displayName = "TabTitle";
var _default = exports.default = TabTitle;