"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StyledHintText = exports.ErrorBorder = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _fieldHelp = _interopRequireDefault(require("../../__internal__/field-help/field-help.style"));
var _hiddenCheckableInput = _interopRequireDefault(require("../../__internal__/checkable-input/hidden-checkable-input.style"));
var _label = require("../../__internal__/label/label.style");
var _checkableInput = require("../../__internal__/checkable-input/checkable-input.style");
var _switchSlider = _interopRequireDefault(require("./__internal__/switch-slider.style"));
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.style"));
var _formField = require("../../__internal__/form-field/form-field.style");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const ErrorBorder = exports.ErrorBorder = _styledComponents.default.span`
  ${({
  warning
}) => (0, _styledComponents.css)`
      position: absolute;
      z-index: 6;
      width: 2px;
      background-color: ${warning ? "var(--colorsSemanticCaution500)" : "var(--colorsSemanticNegative500)"};
      left: -12px;
      bottom: -4px;
      top: 2px;
    `}
`;
const StyledHintText = exports.StyledHintText = _styledComponents.default.div`
  margin-top: 8px;
  margin-bottom: 8px;
  color: var(--colorsUtilityYin055);
  font-size: 14px;
  font-weight: 400;
`;
const StyledSwitch = _styledComponents.default.div`
  ${({
  fieldHelpInline,
  labelInline,
  reverse,
  size,
  theme
}) => (0, _styledComponents.css)`
    ${_styledSystem.margin}
    ${_formField.FieldLineStyle} {
      display: flex;
      flex-flow: row wrap;
    }

    ${_checkableInput.StyledCheckableInput}, ${_hiddenCheckableInput.default} {
      border: none;
      box-sizing: border-box;
      height: 24px;
      width: 60px;
      min-width: fit-content;
      flex-basis: 100%;
      margin-left: 0;
    }

    ${_hiddenCheckableInput.default}:not([disabled]) {
      &:focus + ${_switchSlider.default} {
        ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
      }
    }

    ${_fieldHelp.default} {
      margin-left: 0;
    }

    ${_label.StyledLabelContainer} {
      ${!labelInline && (0, _styledComponents.css)`
        padding: 0;
      `};
      margin-bottom: 8px;

      ${_validationIcon.default} {
        position: relative;
        display: inline-block;
      }
    }

    ${fieldHelpInline && (0, _styledComponents.css)`
      ${_fieldHelp.default} {
        margin: 0;
      }
    `}

    ${reverse && (0, _styledComponents.css)`
      ${!labelInline && (0, _styledComponents.css)`
        ${_label.StyledLabelContainer} {
          margin-top: 8px;
        }

        ${fieldHelpInline && (0, _styledComponents.css)`
          ${_fieldHelp.default} {
            margin-top: 8px;
          }
        `}
      `}
    `}

    ${labelInline && (0, _styledComponents.css)`
      ${_checkableInput.StyledCheckableInput} {
        flex-basis: auto;
      }

      ${_formField.FieldLineStyle} {
        display: flex;
      }

      ${_label.StyledLabelContainer} {
        margin-bottom: 0;
      }

      ${_fieldHelp.default} {
        margin-bottom: 0;
        margin-top: 0;
      }

      ${reverse && (0, _styledComponents.css)`
        ${_checkableInput.StyledCheckableInput} {
          margin-left: 0;
          margin-top: 0;
        }

        ${!fieldHelpInline && (0, _styledComponents.css)`
          ${_fieldHelp.default} {
            margin-left: 60px;
          }
        `}
      `}

      ${fieldHelpInline && (0, _styledComponents.css)`
        ${!reverse && `
          ${_checkableInput.StyledCheckableInput} {
            margin-left: 10px;
          }
        `}

        ${_label.StyledLabelContainer} {
          margin-right: 10px;
        }

        ${_fieldHelp.default} {
          margin-left: 0;
          align-self: center;
        }
      `}
    `}

    ${size === "large" && (0, _styledComponents.css)`
      ${_checkableInput.StyledCheckableInput}, ${_hiddenCheckableInput.default}, ${_switchSlider.default} {
        height: 44px;
        width: 82px;
        min-width: fit-content;
      }

      ${labelInline && !fieldHelpInline && reverse && (0, _styledComponents.css)`
        ${_fieldHelp.default} {
          padding: 10px 0;
        }
      `}

      ${labelInline && (0, _styledComponents.css)`
        ${_label.StyledLabelContainer} {
          margin-top: 1px;
          padding-top: 10px;
          padding-bottom: 10px;
        }

        ${!fieldHelpInline && reverse && (0, _styledComponents.css)`
          ${_fieldHelp.default} {
            margin-left: 78px;
          }
        `}
      `}
    `}
  `}
`;
StyledSwitch.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSwitch;