import React from "react";
import { MarginProps } from "styled-system";
import { CommonCheckableInputProps } from "../../__internal__/checkable-input";
export interface SwitchProps extends CommonCheckableInputProps, MarginProps {
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Set the default value of the Switch if component is meant to be used as uncontrolled */
    defaultChecked?: boolean;
    /** When true label is inline */
    labelInline?: boolean;
    /** Triggers loading animation */
    loading?: boolean;
    /** When true, validation icon will be placed on label instead of being placed on the input */
    validationOnLabel?: boolean;
    /** The value of the switch, passed on form submit */
    value?: string;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
}
export declare const Switch: React.ForwardRefExoticComponent<SwitchProps & React.RefAttributes<HTMLInputElement>>;
export default Switch;
