"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _switchSliderPanel = _interopRequireDefault(require("./switch-slider-panel.style"));
var _validationIcon = _interopRequireDefault(require("../../../__internal__/validations/validation-icon.style"));
var _base = _interopRequireDefault(require("../../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSwitchSlider = _styledComponents.default.span`
  ${({
  checked,
  isLoading,
  disabled,
  size,
  error,
  warning,
  theme
}) => (0, _styledComponents.css)`
    display: flex;
    font-size: 12px;
    font-weight: bold;
    height: 28px;
    left: 0;
    letter-spacing: 1px;
    position: absolute;
    text-transform: uppercase;
    top: 0;
    width: 64px;
    min-width: fit-content;
    z-index: 2;
    border-radius: ${theme?.roundedCornersOptOut ? "90px" : "var(--borderRadius400)"};
    border-style: solid;
    border-color: var(--colorsActionMinor400);
    border-width: var(--borderWidth200);
    box-sizing: border-box;

    &::before {
      background-color: var(--colorsActionMinor400);
      bottom: 4px;
      content: "";
      height: 16px;
      position: absolute;
      left: 4px;
      transition: transform 0.4s;
      width: 16px;
      z-index: 1;
      border-radius: 50%;
    }

    ${checked && `
      background-color: var(--colorsActionMinor500);
      border-color: var(--colorsActionMinorTransparent);

      &::before {
        transform: translateX(36px);
        background-color: var(--colorsActionMinorYang100);
      }

    `}

    ${disabled && !isLoading && (0, _styledComponents.css)`
      border-color: var(--colorsActionDisabled600);

      &::before {
        background-color: var(--colorsActionDisabled600);
      }

      ${_switchSliderPanel.default} {
        color: var(--colorsUtilityYin030);
      }

      ${checked && `
        background-color: var(--colorsActionDisabled500);
        border-color: var(--colorsActionMinorTransparent);

        &::before {
          background-color: var(--colorsActionMinorYang100);
        }

        ${_switchSliderPanel.default} { color: var(--colorsUtilityYin030); }
      `}
    `}

    ${size === "large" && (0, _styledComponents.css)`
      ${theme?.roundedCornersOptOut ? "border-radius: 30px;" : ""}
      &::before {
        height: 32px;
        width: 32px;

        ${checked && `
          transform: translateX(38px);
        `}
      }
    `}

    ${isLoading && (0, _styledComponents.css)`
      &::before {
        display: none;
      }
    `}

    ${warning && !disabled && (0, _styledComponents.css)`
      border-color: var(--colorsSemanticCaution500);
    `}

    ${error && !disabled && (0, _styledComponents.css)`
      border-color: var(--colorsSemanticNegative500);
    `}

    ${_validationIcon.default} {
      position: absolute;
      right: -30px;
      height: 100%;
    }
  `}
`;
StyledSwitchSlider.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSwitchSlider;