"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _loader = _interopRequireDefault(require("../../loader/loader.component"));
var _switchSlider = _interopRequireDefault(require("./switch-slider.style"));
var _switchSliderPanel = _interopRequireDefault(require("./switch-slider-panel.style"));
var _validationIcon = _interopRequireDefault(require("../../../__internal__/validations/validation-icon.component"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const SwitchSlider = ({
  checked,
  disabled,
  loading,
  size,
  error,
  warning,
  info,
  useValidationIcon
}) => {
  const l = (0, _useLocale.default)();
  const panelContent = checked ? l.switch.on() : l.switch.off();
  const switchSliderStyleProps = {
    isLoading: loading,
    checked,
    disabled,
    size,
    error,
    warning,
    info
  };
  const sliderPanelStyleProps = {
    isLoading: loading,
    size,
    type: checked ? "on" : "off",
    disabled
  };
  const loaderProps = {
    isInsideButton: true,
    isActive: checked,
    size
  };
  const sliderContent = /*#__PURE__*/_react.default.createElement(_switchSliderPanel.default, sliderPanelStyleProps, loading ? /*#__PURE__*/_react.default.createElement(_loader.default, loaderProps) : panelContent);
  return /*#__PURE__*/_react.default.createElement(_switchSlider.default, switchSliderStyleProps, sliderContent, useValidationIcon && /*#__PURE__*/_react.default.createElement(_validationIcon.default, {
    error: error,
    warning: warning,
    info: info,
    size: size,
    tooltipFlipOverrides: ["top", "bottom"]
  }));
};
var _default = exports.default = SwitchSlider;