"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _loader = _interopRequireDefault(require("../../loader/loader.style"));
var _loaderSquare = _interopRequireDefault(require("../../loader/loader-square.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SwitchSliderPanel = _styledComponents.default.div`
  ${({
  isLoading,
  size
}) => (0, _styledComponents.css)`
    border: 0;
    color: var(--colorsActionMinorYang100);
    margin: auto;
    margin-top: ${size === "large" ? "12px" : "5px"};

    &[type="on"] {
      margin-left: 9px;
    }

    &[type="off"] {
      color: var(--colorsActionMinor500);
      margin-right: 6px;
    }

    ${isLoading && (0, _styledComponents.css)`
      &[type="off"],
      &[type="on"] {
        margin: 0;
        width: 100%;
        box-sizing: border-box;
        padding: 2px 8px;
      }

      &[type="off"] {
        ${_loaderSquare.default} {
          background-color: var(--colorsSemanticNeutral500);
        }
      }

      &[type="on"] {
        ${_loaderSquare.default} {
          background-color: var(--colorsActionMinorYang100);
        }
      }

      ${_loader.default} {
         {
          display: flex;
          justify-content: center;
          align-items: center;
          width: 100%;
          height: 100%;

          ${_loaderSquare.default} {
            height: ${size === "large" ? "var(--sizing200)" : "var(--sizing150)"};
            width: ${size === "large" ? "var(--sizing200)" : "var(--sizing150)"};
          }
        }
      }
    `}
  `}
`;
var _default = exports.default = SwitchSliderPanel;