"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StepSequenceContext = exports.StepSequence = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _stepSequence = _interopRequireDefault(require("./step-sequence.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StepSequenceContext = exports.StepSequenceContext = /*#__PURE__*/_react.default.createContext({
  orientation: "horizontal"
});
let deprecateWarnTriggered = false;
const StepSequence = ({
  children,
  orientation = "horizontal",
  ...props
}) => {
  if (!deprecateWarnTriggered) {
    deprecateWarnTriggered = true;
    _logger.default.deprecate("The `StepSequence` component is deprecated and will soon be removed," + " please use the `StepFlow` component instead.");
  }
  return /*#__PURE__*/_react.default.createElement(_stepSequence.default, _extends({
    "data-component": "step-sequence",
    orientation: orientation,
    p: 0
  }, props), /*#__PURE__*/_react.default.createElement(StepSequenceContext.Provider, {
    value: {
      orientation
    }
  }, children));
};
exports.StepSequence = StepSequence;
var _default = exports.default = StepSequence;