"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledStepSequenceItemIndicator = exports.StyledStepSequenceItemHiddenLabel = exports.StyledStepSequenceItemContent = exports.StyledStepSequenceItem = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _icon = _interopRequireDefault(require("../../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledStepSequenceItem = exports.StyledStepSequenceItem = _styledComponents.default.li`
  display: flex;
  align-items: center;
  flex-grow: 1;
  text-align: right;
  list-style-type: none;
  color: var(--colorsUtilityYin055);

  ${({
  orientation,
  status
}) => {
  const side = orientation === "vertical" ? "left" : "top";
  return (0, _styledComponents.css)`
      &::before {
        content: "";
        flex-grow: 1;
        display: block;
        margin: 0 16px;
        border-${side}: var(--sizing025) dashed var(--colorsUtilityYin055);
      }

      & span {
        display: flex;
        align-items: center;
        justify-content: center;
      }

      ${_icon.default} {
        margin-right: 8px;
        color: var(--colorsBaseTheme, var(--colorsSemanticPositive500));
      }

      &:first-child {
        flex-grow: 0;

        &::before {
          display: none;
        }
      }

      ${status === "current" && (0, _styledComponents.css)`
          color: var(--colorsUtilityYin090);

          &::before {
            border-${side}-color: var(--colorsUtilityYin090);
            border-${side}-style: solid;
          }
        `}

      ${status === "complete" && (0, _styledComponents.css)`
          color: var(--colorsBaseTheme, var(--colorsSemanticPositive500));

          &::before {
            border-${side}-color: var(
              --colorsBaseTheme,
              var(--colorsSemanticPositive500)
            );
            border-${side}-style: solid;
          }
        `}

      ${orientation === "vertical" && (0, _styledComponents.css)`
          flex-direction: column;
          align-items: flex-start;

          &::before {
            flex-grow: 0;
            border-left-width: var(--sizing025);
            height: 100%;
            min-height: var(--sizing300);
            margin: 12px 8px;
          }
        `}
    `;
}}
`;
const StyledStepSequenceItemContent = exports.StyledStepSequenceItemContent = _styledComponents.default.span`
  display: flex;
`;
const StyledStepSequenceItemHiddenLabel = exports.StyledStepSequenceItemHiddenLabel = _styledComponents.default.span`
  position: absolute !important;
  height: 1px;
  width: 1px;
  overflow: hidden;
  clip: rect(1px, 1px, 1px, 1px);
`;
const StyledStepSequenceItemIndicator = exports.StyledStepSequenceItemIndicator = _styledComponents.default.span`
  display: block;
  min-width: 16px;
  height: 16px;
  margin-right: 8px;
  text-align: center;
`;