"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StepSequenceItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _stepSequenceItem = require("./step-sequence-item.style");
var _icon = _interopRequireDefault(require("../../icon"));
var _stepSequence = require("../step-sequence.component");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StepSequenceItem = ({
  hideIndicator = false,
  indicator,
  status = "incomplete",
  hiddenCompleteLabel,
  hiddenCurrentLabel,
  children,
  ariaLabel,
  ...rest
}) => {
  const {
    orientation
  } = (0, _react.useContext)(_stepSequence.StepSequenceContext);
  const indicatorText = () => {
    return !hideIndicator ? /*#__PURE__*/_react.default.createElement(_stepSequenceItem.StyledStepSequenceItemIndicator, null, indicator) : null;
  };
  const icon = () => status === "complete" ? /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "tick"
  }) : indicatorText();
  const hiddenLabel = () => {
    if (hiddenCompleteLabel && status === "complete") {
      return /*#__PURE__*/_react.default.createElement(_stepSequenceItem.StyledStepSequenceItemHiddenLabel, null, hiddenCompleteLabel);
    }
    if (hiddenCurrentLabel && status === "current") {
      return /*#__PURE__*/_react.default.createElement(_stepSequenceItem.StyledStepSequenceItemHiddenLabel, null, hiddenCurrentLabel);
    }
    return null;
  };
  return /*#__PURE__*/_react.default.createElement(_stepSequenceItem.StyledStepSequenceItem, _extends({
    "data-component": "step-sequence-item",
    orientation: orientation,
    status: status,
    key: `step-seq-item-${indicator}`,
    "aria-label": ariaLabel
  }, rest), hiddenLabel(), /*#__PURE__*/_react.default.createElement(_stepSequenceItem.StyledStepSequenceItemContent, null, icon(), /*#__PURE__*/_react.default.createElement("span", null, children)));
};
exports.StepSequenceItem = StepSequenceItem;
var _default = exports.default = StepSequenceItem;