import React from "react";
export interface StepSequenceItemProps {
    /** Aria label */
    ariaLabel?: string;
    /** Hidden label to be displayed if item is complete */
    hiddenCompleteLabel?: string;
    /** Hidden label to be displayed if item is current */
    hiddenCurrentLabel?: string;
    /** Value to be displayed before text for uncomplete steps */
    indicator: string;
    /** Flag to hide the indicator for uncomplete steps */
    hideIndicator?: boolean;
    /** Status for the step */
    status?: "complete" | "current" | "incomplete";
    /** Content to be displayed */
    children: React.ReactNode;
}
export declare const StepSequenceItem: ({ hideIndicator, indicator, status, hiddenCompleteLabel, hiddenCurrentLabel, children, ariaLabel, ...rest }: StepSequenceItemProps) => React.JSX.Element;
export default StepSequenceItem;
