"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTitleFocusWrapper = exports.StyledStepLabelAndProgress = exports.StyledStepFlow = exports.StyledStepContentText = exports.StyledStepContent = exports.StyledProgressIndicatorBar = exports.StyledProgressIndicator = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _styledSystem = require("styled-system");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledStepFlow = exports.StyledStepFlow = _styledComponents.default.div`
  ${_styledSystem.margin}
`;
const StyledStepContent = exports.StyledStepContent = _styledComponents.default.div`
  display: flex;
  justify-content: space-between;
  margin-bottom: var(--sizing200);
`;
const StyledStepContentText = exports.StyledStepContentText = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
`;
const StyledTitleFocusWrapper = exports.StyledTitleFocusWrapper = _styledComponents.default.div``;
const StyledStepLabelAndProgress = exports.StyledStepLabelAndProgress = _styledComponents.default.div`
  margin-top: var(--sizing125);
`;
const StyledProgressIndicatorBar = exports.StyledProgressIndicatorBar = _styledComponents.default.div`
  display: flex;
  margin-top: var(--sizing100);
`;
function calculateProgressIndicatorColor({
  isCompleted,
  isInProgress
}) {
  if (isInProgress) {
    return "var(--colorsUtilityYin090)";
  }
  if (isCompleted) {
    return "var(--colorsSemanticPositive500)";
  }
  return "var(--colorsActionDisabled600)";
}
const StyledProgressIndicator = exports.StyledProgressIndicator = _styledComponents.default.span`
  background-color: ${calculateProgressIndicatorColor};
  width: 100%;
  height: 8px;
  border-radius: 8px;
  margin-right: 12px;
`;