"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.StepFlow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _icon = _interopRequireDefault(require("../icon"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _stepFlow = require("./step-flow.style");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _typography = _interopRequireDefault(require("../typography"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const StepFlow = exports.StepFlow = /*#__PURE__*/(0, _react.forwardRef)(({
  category,
  title,
  titleVariant,
  totalSteps,
  currentStep,
  showProgressIndicator = false,
  showCloseIcon = false,
  onDismiss,
  ...rest
}, ref) => {
  const totalStepsArray = Array.from({
    length: totalSteps
  }, (_, index) => index + 1);
  const validatedCurrentStep = currentStep > totalSteps ? totalSteps : currentStep;
  let currentStepWarnTriggered = false;
  let noRefWarnTriggered = false;

  /* eslint-disable no-console */
  if (!currentStepWarnTriggered && currentStep > totalSteps) {
    currentStepWarnTriggered = true;
    console.warn("[WARNING] The `currentStep` prop should not be higher than the `totalSteps`prop in `StepFlow`." + " Please ensure `currentStep`s value does not exceed that of `totalSteps`, in the meantime" + " we have set `currentStep` value to that of `totalSteps`, and all indicators have been marked as completed.");
  }
  if (!noRefWarnTriggered && !ref) {
    noRefWarnTriggered = true;
    console.warn("[WARNING] A `ref` should be provided to ensure focus is programmatically focused back to a title div," + " this ensures screen reader users are informed regarding any changes and can navigate back down the page.");
  }
  const progressIndicators = totalStepsArray.map(step => {
    const generateDataState = () => {
      if (step === validatedCurrentStep) {
        return "in-progress";
      }
      if (step < validatedCurrentStep) {
        return "is-completed";
      }
      return "not-completed";
    };
    return /*#__PURE__*/_react.default.createElement(_stepFlow.StyledProgressIndicator, {
      key: step,
      "aria-hidden": "true",
      "data-element": "progress-indicator",
      isCompleted: step < validatedCurrentStep,
      isInProgress: step === validatedCurrentStep,
      "data-state": generateDataState()
    }, "\xA0");
  });
  const locale = (0, _useLocale.default)();
  const closeIcon = /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    "data-element": "close",
    "aria-label": locale.stepFlow.closeIconAriaLabel?.(),
    onClick: onDismiss
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "close"
  }));
  const titleRef = (0, _react.useRef)(null);
  (0, _react.useImperativeHandle)(ref, () => ({
    focus() {
      titleRef.current?.focus();
    }
  }), []);
  const stepFlowTitle = /*#__PURE__*/_react.default.createElement(_stepFlow.StyledTitleFocusWrapper, {
    "data-element": "title-text-wrapper",
    tabIndex: -1,
    ref: titleRef
  }, /*#__PURE__*/_react.default.createElement(_typography.default, {
    variant: titleVariant || "h1",
    "data-element": "title-text"
  }, /*#__PURE__*/_react.default.createElement(_typography.default, {
    fontWeight: "900",
    fontSize: "var(--fontSizes600)",
    lineHeight: "var(--sizing375)",
    variant: "span",
    "aria-hidden": "true",
    "data-element": "visible-title-text"
  }, title), /*#__PURE__*/_react.default.createElement(_typography.default, {
    variant: "span",
    "data-element": "visually-hidden-title-text",
    screenReaderOnly: true
  }, locale.stepFlow.screenReaderOnlyTitle(title, validatedCurrentStep, totalSteps, category))));
  const stepFlowLabel = /*#__PURE__*/_react.default.createElement(_typography.default, {
    variant: "span",
    fontWeight: "400",
    fontSize: "var(--fontSizes200)",
    lineHeight: "var(--sizing300)",
    "data-element": "step-label",
    "aria-hidden": "true"
  }, locale.stepFlow.stepLabel(validatedCurrentStep, totalSteps));
  return /*#__PURE__*/_react.default.createElement(_stepFlow.StyledStepFlow, _extends({}, rest, (0, _tags.default)("step-flow", rest)), /*#__PURE__*/_react.default.createElement(_stepFlow.StyledStepContent, null, category ? /*#__PURE__*/_react.default.createElement(_stepFlow.StyledStepContentText, null, /*#__PURE__*/_react.default.createElement(_typography.default, {
    fontWeight: "500",
    fontSize: "var(--fontSizes100)",
    lineHeight: "var(--sizing250)",
    variant: "span",
    "data-element": "category-text",
    "aria-hidden": "true"
  }, category), stepFlowTitle) : stepFlowTitle, showCloseIcon ? closeIcon : null), showProgressIndicator ? /*#__PURE__*/_react.default.createElement(_stepFlow.StyledStepLabelAndProgress, null, stepFlowLabel, /*#__PURE__*/_react.default.createElement(_stepFlow.StyledProgressIndicatorBar, {
    "data-element": "progress-indicator-bar"
  }, progressIndicators)) : stepFlowLabel);
});
if (process.env.NODE_ENV !== "production") {
  StepFlow.propTypes = {
    "category": _propTypes.default.string,
    "children": _propTypes.default.node,
    "currentStep": _propTypes.default.oneOf([1, 2, 3, 4, 5, 6, 7, 8]).isRequired,
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "onDismiss": _propTypes.default.func,
    "showCloseIcon": _propTypes.default.bool,
    "showProgressIndicator": _propTypes.default.bool,
    "title": _propTypes.default.string.isRequired,
    "titleVariant": _propTypes.default.oneOf(["h1", "h2"]),
    "totalSteps": _propTypes.default.oneOf([1, 2, 3, 4, 5, 6, 7, 8]).isRequired
  };
}
var _default = exports.default = StepFlow;