"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _button = _interopRequireDefault(require("../button/button.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSplitButton = _styledComponents.default.div`
  ${_styledSystem.margin}
  display: inline-block;
  position: relative;

  ${_button.default}:first-of-type {
    border-top-right-radius: var(--borderRadius000);
    border-bottom-right-radius: var(--borderRadius000);
  }

  & > ${_button.default} {
    margin: 0;
    &:focus {
      ${({
  theme
}) => (0, _styledComponents.css)`
        ${theme.focusRedesignOptOut && /* istanbul ignore next */
`
          border: 3px solid var(--colorsSemanticFocus500);
          margin: -1px;
          outline: none;
        `}

        ${!theme.focusRedesignOptOut && `
          position: relative;
          z-index: 1;
        `}
      `}
    }
  }
`;
StyledSplitButton.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSplitButton;