"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SplitButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styledComponents = require("styled-components");
var _dom = require("@floating-ui/dom");
var _useClickAwayListener = _interopRequireDefault(require("../../hooks/__internal__/useClickAwayListener"));
var _icon = _interopRequireDefault(require("../icon"));
var _button = _interopRequireDefault(require("../button"));
var _splitButton = _interopRequireDefault(require("./split-button.style"));
var _splitButtonToggle = _interopRequireDefault(require("./split-button-toggle.style"));
var _splitButtonChildren = _interopRequireDefault(require("./split-button-children.style"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _popover = _interopRequireDefault(require("../../__internal__/popover"));
var _utils = require("../../style/utils");
var _themes = require("../../style/themes");
var _useChildButtons = _interopRequireDefault(require("../../hooks/__internal__/useChildButtons"));
var _splitButton2 = _interopRequireDefault(require("./__internal__/split-button.context"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const CONTENT_WIDTH_RATIO = 0.75;
const SplitButton = ({
  align = "left",
  buttonType = "secondary",
  children,
  disabled = false,
  iconPosition = "before",
  iconType,
  onClick,
  size = "medium",
  subtext,
  text,
  "data-element": dataElement,
  "data-role": dataRole,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const locale = (0, _useLocale.default)();
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext) || _themes.baseTheme;
  const buttonLabelId = (0, _react.useRef)((0, _guid.default)());
  const toggleButton = (0, _react.useRef)(null);
  const {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  } = (0, _useChildButtons.default)(toggleButton, CONTENT_WIDTH_RATIO);
  const mainButtonProps = {
    onMouseEnter: hideButtons,
    onFocus: hideButtons,
    onTouchStart: hideButtons,
    iconPosition,
    buttonType,
    disabled,
    iconType,
    onClick: onClick,
    size,
    subtext,
    ...(0, _utils.filterOutStyledSystemSpacingProps)(rest)
  };
  const toggleButtonProps = {
    disabled,
    displayed: showAdditionalButtons,
    onTouchStart: showButtons,
    onKeyDown: handleToggleButtonKeyDown,
    onClick: showButtons,
    buttonType,
    size
  };
  function componentTags() {
    return {
      "data-component": "split-button",
      "data-element": dataElement,
      "data-role": dataRole
    };
  }
  function getIconColor() {
    const colorsMap = {
      primary: theme.colors.white,
      secondary: theme.colors.primary
    };
    return colorsMap[buttonType];
  }
  function renderMainButton() {
    return [/*#__PURE__*/_react.default.createElement(_button.default, _extends({
      "data-element": "main-button",
      key: "main-button",
      id: buttonLabelId.current
    }, mainButtonProps), text), /*#__PURE__*/_react.default.createElement(_splitButtonToggle.default, _extends({
      "aria-haspopup": "true",
      "aria-expanded": showAdditionalButtons,
      "aria-label": ariaLabel || locale.splitButton.ariaLabel(),
      "data-element": "toggle-button",
      key: "toggle-button",
      type: "button",
      ref: toggleButton
    }, toggleButtonProps), /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "dropdown",
      color: getIconColor(),
      bg: "transparent",
      disabled: disabled
    }))];
  }
  function renderAdditionalButtons() {
    if (!showAdditionalButtons) return null;
    return /*#__PURE__*/_react.default.createElement(_popover.default, {
      placement: "bottom-end",
      reference: buttonNode,
      middleware: [(0, _dom.offset)(6), (0, _dom.flip)({
        fallbackStrategy: "initialPlacement"
      })]
    }, /*#__PURE__*/_react.default.createElement(_splitButtonChildren.default, _extends({}, wrapperProps, {
      align: align
    }), /*#__PURE__*/_react.default.createElement(_splitButton2.default.Provider, {
      value: contextValue
    }, _react.default.Children.map(children, child => /*#__PURE__*/_react.default.createElement("li", null, child)))));
  }
  const handleClick = (0, _useClickAwayListener.default)(hideButtons);
  const marginProps = (0, _utils.filterStyledSystemMarginProps)(rest);
  return /*#__PURE__*/_react.default.createElement(_splitButton.default, _extends({
    onClick: handleClick,
    ref: buttonNode
  }, componentTags(), marginProps), renderMainButton(), renderAdditionalButtons());
};
exports.SplitButton = SplitButton;
var _default = exports.default = SplitButton;