import React from "react";
import { MarginProps } from "styled-system";
import { IconType } from "../icon";
export interface SplitButtonProps extends React.ButtonHTMLAttributes<HTMLButtonElement>, MarginProps {
    /** Set align of the rendered content */
    align?: "left" | "right";
    /** Button type: "primary" | "secondary" */
    buttonType?: "primary" | "secondary";
    /** The additional button to display. */
    children: React.ReactNode;
    /** A custom value for the data-element attribute */
    "data-element"?: string;
    /** A custom value for the data-role attribute */
    "data-role"?: string;
    /** Prop to specify an aria-label for the component */
    "aria-label"?: string;
    /** Gives the button a disabled state. */
    disabled?: boolean;
    /** Defines an Icon position within the button: "before" | "after" */
    iconPosition?: "before" | "after";
    /** Defines an Icon type within the button */
    iconType?: IconType;
    /** The size of the buttons in the SplitButton. */
    size?: "small" | "medium" | "large";
    /** Second text child, renders under main text, only when size is "large" */
    subtext?: string;
    /** The text to be displayed in the SplitButton. */
    text: string;
}
export declare const SplitButton: ({ align, buttonType, children, disabled, iconPosition, iconType, onClick, size, subtext, text, "data-element": dataElement, "data-role": dataRole, "aria-label": ariaLabel, ...rest }: SplitButtonProps) => React.JSX.Element;
export default SplitButton;
