"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _button = _interopRequireDefault(require("../button/button.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const horizontalPaddingSizes = {
  small: 5,
  medium: 10,
  large: 14
};
const StyledSplitButtonToggle = (0, _styledComponents.default)(_button.default)`
  ${({
  buttonType,
  disabled,
  displayed,
  size,
  theme
}) => (0, _styledComponents.css)`
    border-top-left-radius: var(--borderRadius000);
    border-bottom-left-radius: var(--borderRadius000);

    ${!disabled && displayed ? (0, _styledComponents.css)`
          background-color: var(--colorsActionMajor500);
          border-color: var(--colorsActionMajor500);

          &,
          ${_icon.default} {
            color: var(--colorsActionMajorYang100);
          }

          &:focus {
            border-left-color: var(--colorsSemanticFocus500);
          }
        ` : ""}
    ${!disabled && buttonType === "primary" && `
      position: relative;
      &::before {
        content: '';
        width: 2px;
        height: 100%;
        background: var(--colorsActionMajorYang100);
        position: absolute;
        left: -2px;
        z-index: 2;
      }  
    `}

    ${buttonType === "secondary" && "border-left-width: 0;"}
    padding: 0 ${horizontalPaddingSizes[size]}px;

    ${_button.default} + & {
      margin-left: 0;

      ${buttonType === "secondary" && /* istanbul ignore next */
theme.focusRedesignOptOut && /* istanbul ignore next */
(0, _styledComponents.css)`
        &:focus {
          margin-left: -3px;
        }
      `}
    }

    ${_button.default} + & ${_icon.default} {
      margin-left: 0;
    }

    &:focus {
      background-color: var(--colorsActionMajor700);
      border-color: var(--colorsActionMajor700);

      &,
      ${_icon.default} {
        color: var(--colorsActionMajorYang100);
      }
    }
  `}
`;
StyledSplitButtonToggle.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSplitButtonToggle;