"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.borderRadiusStyling = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _button = _interopRequireDefault(require("../button/button.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const borderRadiusStyling = exports.borderRadiusStyling = `
  > {
    &:first-child:last-child > * {
      border-radius: var(--borderRadius100);
    }

    &:first-child:not(:last-child) > * {
      border-top-left-radius: var(--borderRadius100);
      border-top-right-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius000);
      border-bottom-left-radius: var(--borderRadius000);
    }

    &:not(:first-child):not(:last-child) > * {
      border-radius: var(--borderRadius000);
    }

    &:last-child:not(:first-child) > * {
      border-top-right-radius: var(--borderRadius000);
      border-top-left-radius: var(--borderRadius000);
      border-bottom-left-radius: var(--borderRadius100);
      border-bottom-right-radius: var(--borderRadius100);
    }
  }
`;
const StyledSplitButtonChildrenContainer = _styledComponents.default.ul`
  border-radius: var(--borderRadius100);
  ${({
  theme,
  align,
  minWidth
}) => (0, _styledComponents.css)`
    background-color: var(--colorsActionMajorYang100);
    min-width: ${minWidth}px;
    white-space: nowrap;
    z-index: ${theme.zIndex.popover};
    box-shadow: var(--boxShadow100);
    list-style: none;
    padding: 0;
    margin: 0;

    ${borderRadiusStyling}

    ${_button.default} {
      border: 1px solid var(--colorsActionMajorTransparent);
      display: flex;
      justify-content: ${align};
      margin-left: 0;
      min-width: 100%;
      text-align: ${align};
      z-index: ${theme.zIndex.overlay};

      & + & {
        margin-top: 3px;
      }
    }
  `}
`;
StyledSplitButtonChildrenContainer.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSplitButtonChildrenContainer;