"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTickIcon = exports.StyledSimpleColorInput = exports.StyledSimpleColor = exports.StyledColorSampleBox = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _input = require("../../../__internal__/input");
var _checkerBoard = _interopRequireDefault(require("./checker-board.svg"));
var _icon = _interopRequireDefault(require("../../icon"));
var _getRgbValues = _interopRequireDefault(require("../../../style/utils/get-rgb-values"));
var _addFocusStyling = _interopRequireDefault(require("../../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSimpleColor = exports.StyledSimpleColor = _styledComponents.default.div`
  width: var(--sizing700);
  height: var(--sizing700);
  margin-right: 2px;
  margin-bottom: 2px;

  &:hover {
    cursor: pointer;
  }
`;
const oldFocusStyling = `
  box-shadow: inset 0px 0px 0px var(--borderWidth200) var(--colorsUtilityYang100);
  border: 2px solid var(--colorsSemanticFocus500);
`;
const StyledColorSampleBox = exports.StyledColorSampleBox = _styledComponents.default.div`
  height: 100%;
  width: 100%;
  box-sizing: border-box;
  display: flex;
  align-items: center;
  justify-content: center;
  ${({
  theme
}) => /* istanbul ignore next */
theme.focusRedesignOptOut && "border: 2px solid transparent;"}

  ${({
  color
}) => color !== "transparent" && (0, _styledComponents.css)`
      background-color: ${color};
    `}

  ${({
  color
}) => color === "transparent" && (0, _styledComponents.css)`
      background-color: #eeeeee;
      background-image: url(${_checkerBoard.default});
      background-size: 14px 14px;
      background-position: -2px -2px;
    `}
`;
const StyledSimpleColorInput = exports.StyledSimpleColorInput = (0, _styledComponents.default)(_input.Input)`
  position: absolute;
  opacity: 0;
  height: var(--sizing700);
  width: var(--sizing700);
  margin: 0;

  &:hover {
    cursor: pointer;
  }

  &:disabled:hover {
    cursor: not-allowed;
  }

  &:focus + ${StyledColorSampleBox} {
    ${({
  theme
}) => (0, _styledComponents.css)`
      ${theme.focusRedesignOptOut && /* istanbul ignore next */
`
        ${oldFocusStyling}
      `}

      ${!theme.focusRedesignOptOut && `
        ${(0, _addFocusStyling.default)(true)}
      `}
    `}
  }
`;
const getIconColor = color => {
  const rgbValues = (0, _getRgbValues.default)(color);
  const [r, g, b] = rgbValues;
  // color contrast calculating formula as per W3 suggestions
  const redMultiplier = 299,
    greenMultiplier = 587,
    blueMultiplier = 114;
  const contrast = (Math.round(r * redMultiplier) + Math.round(g * greenMultiplier) + Math.round(b * blueMultiplier)) / 1000;
  if (contrast < 128) return "var(--colorsUtilityYang100)";
  return "var(--colorsUtilityYin090)";
};
const StyledTickIcon = exports.StyledTickIcon = (0, _styledComponents.default)(_icon.default)`
  height: 20px;
  width: 20px;
  pointer-events: none;
  display: block;

  &::before {
    font-size: 20px;
    color: ${({
  color
}) => getIconColor(color)};
  }
`;