"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SimpleColor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _simpleColor = require("./simple-color.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SimpleColor = exports.SimpleColor = /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  const {
    onChange,
    onBlur,
    onMouseDown,
    value,
    name,
    checked = false,
    className,
    id,
    defaultChecked,
    ...rest
  } = props;
  const {
    current: inputId
  } = (0, _react.useRef)(id || (0, _guid.default)());
  return /*#__PURE__*/_react.default.createElement(_simpleColor.StyledSimpleColor, _extends({
    className: className
  }, (0, _tags.default)("simple-color", props)), /*#__PURE__*/_react.default.createElement(_simpleColor.StyledSimpleColorInput, _extends({
    onChange: onChange,
    onBlur: onBlur,
    onMouseDown: onMouseDown,
    checked: checked,
    name: name,
    type: "radio",
    role: "radio",
    value: value,
    "aria-checked": checked,
    ref: ref,
    id: inputId,
    defaultChecked: defaultChecked
  }, rest)), /*#__PURE__*/_react.default.createElement(_simpleColor.StyledColorSampleBox, {
    color: value
  }, checked && /*#__PURE__*/_react.default.createElement(_simpleColor.StyledTickIcon, {
    color: value,
    type: "tick"
  })));
});
if (process.env.NODE_ENV !== "production") {
  SimpleColor.propTypes = {
    "checked": _propTypes.default.bool,
    "className": _propTypes.default.string,
    "defaultChecked": _propTypes.default.bool,
    "disabled": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "name": _propTypes.default.string,
    "onBlur": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "value": _propTypes.default.string.isRequired
  };
}
SimpleColor.displayName = "SimpleColor";
var _default = exports.default = SimpleColor;