"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledContent = exports.StyledColorOptions = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BORDER_WIDTH = 2;
const getRoundedMaxWidth = (maxWidth, childWidth) => Math.floor(+maxWidth / +childWidth) * +childWidth;
const StyledContent = exports.StyledContent = _styledComponents.default.div`
  display: flex;
  align-items: center;

  ${_validationIcon.default} {
    margin-left: 4px;
  }
`;
const StyledColorOptions = exports.StyledColorOptions = _styledComponents.default.div`
  max-width: ${({
  maxWidth,
  childWidth
}) => getRoundedMaxWidth(maxWidth, childWidth)}px;

  padding: 0;
  display: flex;
  flex-wrap: wrap;
  border-left: ${BORDER_WIDTH}px solid transparent;
  border-top: ${BORDER_WIDTH}px solid transparent;

  ${({
  error,
  info,
  warning
}) => {
  if (error) return (0, _styledComponents.css)`
        outline: var(--borderWidth200) solid var(--colorsSemanticNegative500);
      `;
  if (warning) return (0, _styledComponents.css)`
        outline: var(--borderWidth200) solid var(--colorsSemanticCaution500);
      `;
  if (info) return (0, _styledComponents.css)`
        outline: var(--borderWidth200) solid var(--colorsSemanticInfo500);
      `;
  return "";
}}
`;