"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SimpleColorPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _fieldset = _interopRequireDefault(require("../../__internal__/fieldset"));
var _simpleColor = _interopRequireDefault(require("./simple-color"));
var _radioButtonMapper = _interopRequireDefault(require("../../__internal__/radio-button-mapper/radio-button-mapper.component"));
var _simpleColorPicker = require("./simple-color-picker.style");
var _validationIcon = _interopRequireDefault(require("../../__internal__/validations/validation-icon.component"));
var _inputBehaviour = require("../../__internal__/input-behaviour");
var _utils = require("../../style/utils");
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const SimpleColorPicker = exports.SimpleColorPicker = /*#__PURE__*/_react.default.forwardRef((props, ref) => {
  const {
    children,
    error,
    warning,
    info,
    name,
    legend,
    onChange,
    onBlur,
    onKeyDown,
    value,
    isBlurBlocked = false,
    maxWidth = 300,
    childWidth = 58,
    validationOnLegend,
    required,
    ...rest
  } = props;
  const hasProperChildren = (0, _react.useMemo)(() => {
    let hasSimpleColorChildren = true;
    _react.default.Children.toArray(children).forEach(child => {
      if (typeof child === "string" || /*#__PURE__*/_react.default.isValidElement(child) && child.type.displayName !== "SimpleColor") {
        hasSimpleColorChildren = false;
      }
    });
    return hasSimpleColorChildren;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `SimpleColorPicker accepts only children of type \`${_simpleColor.default.displayName}\`.`) : (0, _invariant.default)(false) : void 0;
  const filteredChildren = (0, _react.useMemo)(() => _react.default.Children.toArray(children).filter(child => /*#__PURE__*/_react.default.isValidElement(child)), [children]);
  const internalRef = (0, _react.useRef)(null);
  const [blurBlocked, setIsBlurBlocked] = (0, _react.useState)(isBlurBlocked);
  const [focusedElement, setFocusedElement] = (0, _react.useState)(null);
  const itemsPerRow = Math.floor(+maxWidth / +childWidth);
  const rowCount = Math.ceil(filteredChildren?.length / itemsPerRow);
  let blankSlots = itemsPerRow * rowCount - filteredChildren?.length;
  let currentRow = 1;
  let loopCounter = 1;
  const gridItemRefs = (0, _react.useRef)([]);
  const navigationGrid = filteredChildren.map((child, index) => {
    const allowUp = currentRow !== 1;
    let allowDown = false;
    if (currentRow + 1 === rowCount && blankSlots - itemsPerRow < 0) {
      allowDown = true;
      blankSlots += 1;
    } else if (currentRow + 1 !== rowCount && currentRow !== rowCount && rowCount > 1) {
      allowDown = true;
    }
    if (loopCounter === itemsPerRow) {
      loopCounter = 0;
      currentRow += 1;
    }
    let upItem;
    if (allowUp) {
      upItem = index - itemsPerRow;
    }
    let downItem;
    if (allowDown) {
      downItem = itemsPerRow + index;
    }
    const childProps = {
      ref: element => {
        gridItemRefs.current[index] = element;
      },
      "data-up": allowUp,
      "data-down": allowDown,
      "data-item-up": upItem,
      "data-item-down": downItem,
      required
    };
    loopCounter += 1;
    return /*#__PURE__*/_react.default.cloneElement(child, childProps);
  });
  (0, _react.useImperativeHandle)(ref, () => ({
    gridItemRefs: gridItemRefs.current
  }), [gridItemRefs]);
  const getElementPosition = (0, _react.useCallback)(target => {
    return navigationGrid.findIndex(element => {
      return target.getAttribute("value") === element.props.value;
    });
  }, [navigationGrid]);
  const onKeyDownHandler = (0, _react.useCallback)(e => {
    if (onKeyDown) {
      onKeyDown(e);
    }
    const arrowKeys = [_events.default.isLeftKey(e), _events.default.isUpKey(e), _events.default.isRightKey(e), _events.default.isDownKey(e)];
    if (!arrowKeys.includes(true)) return;
    e.preventDefault();
    let itemIndex = null;
    const target = e.target;
    if (_events.default.isUpKey(e)) {
      if (target.getAttribute("data-up") !== "true") return;
      itemIndex = +target.getAttribute("data-item-up");
    } else if (_events.default.isDownKey(e)) {
      if (target.getAttribute("data-down") !== "true") return;
      itemIndex = +target.getAttribute("data-item-down");
    }
    if (_events.default.isLeftKey(e) || _events.default.isRightKey(e)) {
      if (_events.default.isLeftKey(e)) {
        itemIndex = getElementPosition(target) - 1;
      } else {
        itemIndex = getElementPosition(target) + 1;
      }
      if (itemIndex < 0) {
        itemIndex = navigationGrid.length - 1;
      } else if (itemIndex > navigationGrid.length - 1) {
        itemIndex = 0;
      }
    }

    /* istanbul ignore else */
    if (itemIndex !== null) {
      const item = gridItemRefs.current[itemIndex];
      item?.focus();
      item?.click();
    }
  }, [onKeyDown, navigationGrid, getElementPosition]);
  const handleClickOutside = ev => {
    if (internalRef.current && ev.target && !internalRef.current.contains(ev.target)) {
      setIsBlurBlocked(false);
    }
  };
  (0, _react.useEffect)(() => {
    document.addEventListener("mousedown", handleClickOutside);
    document.addEventListener("keydown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
      document.removeEventListener("keydown", handleClickOutside);
    };
  });
  const handleOnBlur = ev => {
    ev.preventDefault();
    if (!blurBlocked && onBlur) {
      onBlur(ev);
    }
  };
  const handleOnMouseDown = ev => {
    setIsBlurBlocked(true);

    // If the mousedown event occurred on the currently-focused <SimpleColor>
    if (focusedElement !== null && focusedElement === ev.target) {
      ev.preventDefault();

      // If a different <SimpleColor> is currently focused
    } else if (focusedElement !== null) {
      ev.preventDefault();
      setIsBlurBlocked(false);
      setFocusedElement(ev.target);

      // If no <SimpleColor> is currently focused
    } else {
      setIsBlurBlocked(true);
      setFocusedElement(ev.target);
    }
  };
  const validationProps = {
    error,
    warning,
    info
  };
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Simple Color Picker` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    role: "radiogroup",
    legend: legend,
    isRequired: required
  }, validationOnLegend && validationProps, (0, _tags.default)("simple-color-picker", props), (0, _utils.filterStyledSystemMarginProps)(rest)), /*#__PURE__*/_react.default.createElement(_simpleColorPicker.StyledContent, null, /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputGroupContext.Consumer, null, ({
    onMouseEnter,
    onMouseLeave
  }) => /*#__PURE__*/_react.default.createElement(_simpleColorPicker.StyledColorOptions, _extends({
    maxWidth: maxWidth,
    childWidth: childWidth,
    ref: internalRef,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, validationProps), /*#__PURE__*/_react.default.createElement(_radioButtonMapper.default, {
    name: name,
    value: value,
    onChange: onChange,
    onMouseDown: handleOnMouseDown,
    onKeyDown: onKeyDownHandler,
    onBlur: handleOnBlur
  }, navigationGrid))), !validationOnLegend && /*#__PURE__*/_react.default.createElement(_validationIcon.default, _extends({}, validationProps, {
    tooltipFlipOverrides: ["top", "bottom"]
  }))));
});
if (process.env.NODE_ENV !== "production") {
  SimpleColorPicker.propTypes = {
    "children": _propTypes.default.node,
    "childWidth": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "isBlurBlocked": _propTypes.default.bool,
    "legend": _propTypes.default.string.isRequired,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "maxWidth": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string.isRequired,
    "onBlur": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "required": _propTypes.default.bool,
    "validationOnLegend": _propTypes.default.bool,
    "value": _propTypes.default.string,
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool])
  };
}
SimpleColorPicker.displayName = "SimpleColorPicker";
var _default = exports.default = SimpleColorPicker;