import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../__internal__/validations";
export interface SimpleColorPickerProps extends ValidationProps, MarginProps {
    /** The SimpleColor components to be rendered in the group */
    children?: React.ReactNode;
    /** prop that represents childWidth */
    childWidth?: string | number;
    /** Should the onBlur callback prop be initially blocked? */
    isBlurBlocked?: boolean;
    /** The content for the Legend */
    legend: string;
    /** prop that sets max-width in css */
    maxWidth?: string | number;
    /** The name to apply to the input. */
    name: string;
    /** Prop for `onChange` events */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** Prop for `onKeyDown` events */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Prop for `onBlur` events */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** When true, validation icon will be placed on legend instead of being placed by the input */
    validationOnLegend?: boolean;
    /** The currently selected color. */
    value?: string;
}
export interface SimpleColorPickerRef {
    /** List of color input HTML refs */
    gridItemRefs: (HTMLInputElement | null)[];
}
export declare const SimpleColorPicker: React.ForwardRefExoticComponent<SimpleColorPickerProps & React.RefAttributes<SimpleColorPickerRef>>;
export default SimpleColorPicker;
