"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _elementSizing = _interopRequireDefault(require("../../style/utils/element-sizing"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _formStyleUtils = require("../../style/utils/form-style-utils");
var _form = require("../form/form.style");
var _sidebar = require("./sidebar.config");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSidebar = _styledComponents.default.div`
  // prevents outline being added in safari
  :focus {
    outline: none;
  }

  ${_form.StyledFormContent} {
    ${props => (0, _formStyleUtils.calculateFormSpacingValues)(props, true, "sidebar")}
  }

  ${_form.StyledFormFooter}.sticky {
    ${_formStyleUtils.calculateWidthValue}
    ${props => (0, _formStyleUtils.calculateFormSpacingValues)(props, false, "sidebar")}
  }

  ${({
  onCancel,
  position,
  size,
  theme,
  width
}) => (0, _styledComponents.css)`
    background: var(--colorsUtilityMajor025);
    border-radius: 1px;
    bottom: 0;
    position: fixed;
    display: flex;
    flex-direction: column;
    top: 0;
    z-index: ${theme.zIndex.fullScreenModal};

    ${!width && size && (0, _styledComponents.css)`
      width: ${_sidebar.SIDEBAR_SIZES_CSS[size]};
    `}
    ${width && (0, _elementSizing.default)({
  width
})}

    ${position && (0, _styledComponents.css)`
      box-shadow: var(--boxShadow300);
      ${position}: 0;
    `}

    ${onCancel && (0, _styledComponents.css)`
      > ${_iconButton.default}:first-of-type {
        position: absolute;
        z-index: 1;
        right: 25px;
        top: 25px;
      }
    `}
  `}
`;
StyledSidebar.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledSidebar;