"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SidebarContext = exports.Sidebar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _modal = _interopRequireDefault(require("../modal"));
var _sidebar = _interopRequireDefault(require("./sidebar.style"));
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _icon = _interopRequireDefault(require("../icon"));
var _focusTrap = _interopRequireDefault(require("../../__internal__/focus-trap"));
var _sidebarHeader = _interopRequireDefault(require("./__internal__/sidebar-header"));
var _box = _interopRequireDefault(require("../box"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _utils = require("../../style/utils");
var _useIsStickyFooterForm = _interopRequireDefault(require("../../hooks/__internal__/useIsStickyFooterForm"));
var _useModalAria = _interopRequireDefault(require("../../hooks/__internal__/useModalAria/useModalAria"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
// TODO FE-5408 will investigate why React.RefObject<T> produces a failed prop type when current = null

const SidebarContext = exports.SidebarContext = /*#__PURE__*/_react.default.createContext({});
const Sidebar = exports.Sidebar = /*#__PURE__*/_react.default.forwardRef(({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  open,
  bespokeFocusTrap,
  disableAutoFocus = false,
  disableEscKey = false,
  enableBackgroundUI = false,
  header,
  position = "right",
  size = "medium",
  children,
  onCancel,
  role = "dialog",
  focusFirstElement,
  focusableContainers,
  focusableSelectors,
  width,
  headerPadding = {},
  topModalOverride,
  ...rest
}, ref) => {
  const locale = (0, _useLocale.default)();
  const {
    current: headerId
  } = (0, _react.useRef)((0, _guid.default)());
  const hasStickyFooter = (0, _useIsStickyFooterForm.default)(children);
  const sidebarRef = (0, _react.useRef)(null);
  const setRefs = (0, _react.useCallback)(reference => {
    sidebarRef.current = reference;
    if (!ref) return;
    if (typeof ref === "object") ref.current = reference;
    if (typeof ref === "function") ref(reference);
  }, [ref]);
  const isTopModal = (0, _useModalAria.default)(sidebarRef);
  const closeIcon = () => {
    if (!onCancel) return null;
    return /*#__PURE__*/_react.default.createElement(_iconButton.default, {
      "aria-label": locale.sidebar.ariaLabels.close(),
      onClick: onCancel,
      "data-element": "close"
    }, /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "close"
    }));
  };
  const componentTags = {
    "data-component": "sidebar",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  const sidebar = /*#__PURE__*/_react.default.createElement(_sidebar.default, _extends({
    "aria-modal": !enableBackgroundUI && isTopModal,
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel,
    "aria-labelledby": !ariaLabelledBy && !ariaLabel ? headerId : ariaLabelledBy,
    ref: setRefs,
    position: position,
    size: size,
    "data-element": "sidebar",
    onCancel: onCancel,
    role: role
  }, (0, _utils.filterStyledSystemPaddingProps)(rest), {
    width: width
  }), header && /*#__PURE__*/_react.default.createElement(_sidebarHeader.default, _extends({
    closeIcon: closeIcon()
  }, headerPadding, {
    id: headerId
  }), header), !header && closeIcon(), /*#__PURE__*/_react.default.createElement(_box.default, _extends({
    "data-element": "sidebar-content",
    pt: "var(--spacing300)",
    pb: "var(--spacing400)",
    px: "var(--spacing400)"
  }, (0, _utils.filterStyledSystemPaddingProps)(rest), {
    scrollVariant: "light",
    overflow: hasStickyFooter ? undefined : "auto",
    flex: "1"
  }), /*#__PURE__*/_react.default.createElement(SidebarContext.Provider, {
    value: {
      isInSidebar: true
    }
  }, children)));
  return /*#__PURE__*/_react.default.createElement(_modal.default, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    enableBackgroundUI: enableBackgroundUI,
    topModalOverride: topModalOverride
  }, componentTags), enableBackgroundUI ? sidebar : /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    wrapperRef: sidebarRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers,
    focusableSelectors: focusableSelectors,
    focusFirstElement: focusFirstElement,
    autoFocus: !disableAutoFocus,
    bespokeTrap: bespokeFocusTrap
  }, sidebar));
});
if (process.env.NODE_ENV !== "production") {
  Sidebar.propTypes = {
    "aria-describedby": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "bespokeFocusTrap": _propTypes.default.func,
    "children": _propTypes.default.node,
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "disableAutoFocus": _propTypes.default.bool,
    "disableEscKey": _propTypes.default.bool,
    "enableBackgroundUI": _propTypes.default.bool,
    "focusableContainers": _propTypes.default.arrayOf(_propTypes.default.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })),
    "focusableSelectors": _propTypes.default.string,
    "focusFirstElement": _propTypes.default.shape({
      "current": _propTypes.default.oneOfType([_propTypes.default.oneOf([null]), function (props, propName) {
        if (props[propName] == null) {
          return new Error("Prop '" + propName + "' is required but wasn't specified");
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }]).isRequired
    }),
    "header": _propTypes.default.node,
    "headerPadding": _propTypes.default.shape({
      "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string]),
      "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
        "__@toStringTag": _propTypes.default.string.isRequired,
        "description": _propTypes.default.string,
        "toString": _propTypes.default.func.isRequired,
        "valueOf": _propTypes.default.func.isRequired
      }), _propTypes.default.string])
    }),
    "onCancel": _propTypes.default.func,
    "open": _propTypes.default.bool.isRequired,
    "p": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "padding": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "paddingY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pl": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "position": _propTypes.default.oneOf(["left", "right"]),
    "pr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "pt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "px": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "py": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "role": _propTypes.default.string,
    "size": _propTypes.default.oneOf(["extra-large", "extra-small", "large", "medium-large", "medium-small", "medium", "small"]),
    "topModalOverride": _propTypes.default.bool,
    "width": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])
  };
}
Sidebar.displayName = "Sidebar";
var _default = exports.default = Sidebar;