import React from "react";
import { PaddingProps, WidthProps } from "styled-system";
import { ModalProps } from "../modal";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
declare type CustomRefObject<T> = {
    current?: T | null;
};
export interface SidebarContextProps {
    isInSidebar?: boolean;
}
export declare const SidebarContext: React.Context<SidebarContextProps>;
export interface SidebarProps extends PaddingProps, TagProps, WidthProps, Pick<ModalProps, "topModalOverride"> {
    /** Prop to specify the aria-describedby property of the component */
    "aria-describedby"?: string;
    /**
     * Prop to specify the aria-label of the component.
     * To be used only when the header prop is not defined, and the component is not labelled by any internal element.
     */
    "aria-label"?: string;
    /**
     * Prop to specify the aria-labeledby property of the component
     * To be used when the header prop is a custom React Node,
     * or the component is labelled by an internal element other than the header.
     */
    "aria-labelledby"?: string;
    /** Modal content */
    children?: React.ReactNode;
    /** Determines if the Esc Key closes the modal */
    disableEscKey?: boolean;
    /** Set this prop to false to hide the translucent background when the dialog is open. */
    enableBackgroundUI?: boolean;
    /** Optional reference to an element meant to be focused on open */
    focusFirstElement?: React.MutableRefObject<HTMLElement | null>;
    disableAutoFocus?: boolean;
    /**
     * Function to replace focus trap
     * @ignore
     * @private
     */
    bespokeFocusTrap?: (ev: KeyboardEvent, firstElement?: HTMLElement, lastElement?: HTMLElement) => void;
    /** Node that will be used as sidebar header. */
    header?: React.ReactNode;
    /** A custom close event handler */
    onCancel?: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLElement>) => void;
    /** Sets the open state of the modal */
    open: boolean;
    /** Sets the position of sidebar, either left or right. */
    position?: "left" | "right";
    /** The ARIA role to be applied to the component container */
    role?: string;
    /** Sets the size of the sidebar when open. */
    size?: "extra-small" | "small" | "medium-small" | "medium" | "medium-large" | "large" | "extra-large";
    /** an optional array of refs to containers whose content should also be reachable by tabbing from the sidebar */
    focusableContainers?: CustomRefObject<HTMLElement>[];
    /** Optional selector to identify the focusable elements, if not provided a default selector is used */
    focusableSelectors?: string;
    /** Padding to be set on the Sidebar header */
    headerPadding?: PaddingProps;
}
export declare const Sidebar: React.ForwardRefExoticComponent<SidebarProps & React.RefAttributes<HTMLDivElement>>;
export default Sidebar;
