"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SettingsRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _heading = _interopRequireDefault(require("../heading"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _utils = require("../../style/utils");
var _settingsRow = require("./settings-row.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const SettingsRow = ({
  title,
  headingType = "h3",
  children,
  description,
  divider = true,
  className,
  ...rest
}) => {
  const heading = () => {
    if (!title) return null;
    return /*#__PURE__*/_react.default.createElement(_heading.default, {
      headingType: headingType,
      title: title,
      subheader: description,
      separator: description !== undefined,
      divider: false
    });
  };
  return /*#__PURE__*/_react.default.createElement(_settingsRow.StyledSettingsRow, _extends({
    className: className,
    hasDivider: divider
  }, (0, _tags.default)("settings-row", rest), {
    m: 0
  }, (0, _utils.filterStyledSystemMarginProps)(rest)), /*#__PURE__*/_react.default.createElement(_settingsRow.StyledSettingsRowHeader, null, heading()), /*#__PURE__*/_react.default.createElement(_settingsRow.StyledSettingsRowInput, null, children));
};
exports.SettingsRow = SettingsRow;
SettingsRow.displayName = "SettingsRow";
var _default = exports.default = SettingsRow;