"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
var _optionRow = _interopRequireDefault(require("../option-row/option-row.style"));
var _option = _interopRequireDefault(require("../option/option.style"));
var _option2 = _interopRequireDefault(require("../option"));
var _optionRow2 = _interopRequireDefault(require("../option-row/option-row.component"));
var _highlightPartOfText = _interopRequireDefault(require("./highlight-part-of-text"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const filterOptions = (option, filterText) => {
  const processedText = option.props.text?.toLowerCase();
  const processedValue = filterText.toLowerCase();
  if (processedText.includes(processedValue)) {
    return option;
  }
  return null;
};
const filterOptionRows = (optionRow, filterText) => {
  const cells = _react.default.Children.toArray(optionRow.props.children);
  const hasText = cells.find(cell => {
    /* istanbul ignore if */
    if (! /*#__PURE__*/_react.default.isValidElement(cell)) {
      return false;
    }
    if (typeof cell.props.children === "string") {
      const processedText = cell.props.children.toLowerCase();
      const processedValue = filterText.toLowerCase();
      return processedText.includes(processedValue);
    }
    // filter recursively based on children
    return filterOptionRows(cell, filterText);
  });
  if (hasText) {
    return optionRow;
  }
  return null;
};
const filterChildren = filterText => children => {
  const filteredChildren = _react.default.Children.map(children, child => {
    /* istanbul ignore if */
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return null;
    }
    if (child.type === _option2.default) {
      return filterOptions(child, filterText);
    }
    /* istanbul ignore else */
    if (child.type === _optionRow2.default) {
      return filterOptionRows(child, filterText);
    }
    /* istanbul ignore next */
    return null;
  });
  if (_react.default.Children.count(filteredChildren)) return filteredChildren;
  return null;
};
function addHighlightedContent(filteredElements, filterText) {
  return _react.default.Children.map(filteredElements, child => {
    let highlightedContent;
    /* istanbul ignore if */
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    if (child.type === _option2.default) {
      highlightedContent = (0, _highlightPartOfText.default)(child.props.text, filterText);
    }
    if (child.type === _optionRow2.default) {
      highlightedContent = _react.default.Children.map(child.props.children, cell => {
        /* istanbul ignore if */
        if (! /*#__PURE__*/_react.default.isValidElement(cell)) {
          return cell;
        }
        return /*#__PURE__*/_react.default.cloneElement(cell, {
          children: (0, _highlightPartOfText.default)(cell.props.children, filterText)
        });
      });
    }
    return /*#__PURE__*/_react.default.cloneElement(child, {
      children: highlightedContent
    });
  });
}
/** Filters wrapped component children based on provided filter text and highlights matching content */
const withFilter = WrappedComponent => {
  const FilteredComponent = /*#__PURE__*/_react.default.forwardRef(({
    children,
    filterText,
    noResultsMessage,
    isLoading,
    multiColumn,
    tableHeader,
    ...props
  }, forwardedRef) => {
    const l = (0, _useLocale.default)();
    const getFilteredChildren = (0, _react.useCallback)(() => {
      let filteredElements = children;
      if (filterText && !isLoading) {
        filteredElements = filterChildren(filterText)(children);
        if (!filteredElements) {
          const noResultsText = l.select.noResultsForTerm(filterText);
          if (multiColumn) {
            const colSpan = /*#__PURE__*/_react.default.isValidElement(tableHeader) ? /* istanbul ignore next */_react.default.Children.count(tableHeader?.props?.children) : 1;
            return /*#__PURE__*/_react.default.createElement(_optionRow.default, null, /*#__PURE__*/_react.default.createElement("td", {
              style: {
                fontWeight: "normal"
              },
              colSpan: colSpan
            }, noResultsMessage || noResultsText));
          }
          return /*#__PURE__*/_react.default.createElement(_option.default, null, noResultsMessage || noResultsText);
        }
        return addHighlightedContent(filteredElements, filterText);
      }
      return children;
    }, [children, filterText, isLoading, multiColumn, noResultsMessage, tableHeader, l]);
    const wrappedComponentProps = {
      filterText,
      isLoading,
      multiColumn,
      tableHeader,
      ...props
    };
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, _extends({}, wrappedComponentProps, {
      ref: forwardedRef
    }), getFilteredChildren());
  });
  FilteredComponent.displayName = "FilteredComponent";
  return FilteredComponent;
};
var _default = exports.default = withFilter;