import React from "react";
interface WrappedComponentProps {
    filterText?: string;
    isLoading?: boolean;
    multiColumn?: boolean;
    tableHeader?: React.ReactNode;
    children?: React.ReactNode;
}
export interface FilteredComponentProps extends WrappedComponentProps {
    noResultsMessage?: string;
}
/** Filters wrapped component children based on provided filter text and highlights matching content */
declare const withFilter: <T extends WrappedComponentProps>(WrappedComponent: React.ComponentType<T>) => React.ForwardRefExoticComponent<React.PropsWithoutRef<FilteredComponentProps & T> & React.RefAttributes<HTMLDivElement>>;
export default withFilter;
