"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isExpectedOption;
var _option = _interopRequireDefault(require("../option"));
var _optionRow = _interopRequireDefault(require("../option-row/option-row.component"));
var _isExpectedValue = _interopRequireDefault(require("./is-expected-value"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function isExpectedOption(element, expectedValue) {
  if (element.type !== _option.default && element.type !== _optionRow.default) {
    return false;
  }
  if (expectedValue === null || expectedValue === undefined) {
    return false;
  }
  const {
    length
  } = typeof expectedValue === "string" ? expectedValue : Object.keys(expectedValue);
  if (!length) {
    return false;
  }
  return (0, _isExpectedValue.default)(element.props.value, expectedValue);
}