"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = highlightPartOfTextRecursive;
var _react = _interopRequireDefault(require("react"));
var _matchingText = _interopRequireDefault(require("./matching-text.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function highlightPartOfText(text, partToHighlight) {
  if (!partToHighlight || !partToHighlight.length || !text) return text;
  const lowercaseText = text.toLowerCase();
  const lowercasePart = partToHighlight.toLowerCase();
  const indexOfFirstMatch = lowercaseText.indexOf(lowercasePart);
  if (indexOfFirstMatch === -1) {
    return text;
  }
  const precedingText = text.substr(0, indexOfFirstMatch);
  const matchingText = text.substr(indexOfFirstMatch, partToHighlight.length);
  const followingText = text.substr(indexOfFirstMatch + partToHighlight.length, text.length);
  let followingTextNode = followingText;
  if (followingText.length >= partToHighlight.length) {
    followingTextNode = highlightPartOfText(followingText, partToHighlight);
  }
  const newValue = [/*#__PURE__*/_react.default.createElement("span", {
    key: "preceding"
  }, precedingText), /*#__PURE__*/_react.default.createElement(_matchingText.default, {
    key: "match"
  }, matchingText), /*#__PURE__*/_react.default.createElement("span", {
    key: "following"
  }, followingTextNode)];
  return newValue;
}
function highlightPartOfTextRecursive(child, partToHighlight) {
  if (typeof child === "string") {
    return highlightPartOfText(child, partToHighlight);
  }
  /* istanbul ignore if */
  if (! /*#__PURE__*/_react.default.isValidElement(child)) {
    return child;
  }
  const highlightedChildren = _react.default.Children.map(child.props.children, grandChild => highlightPartOfTextRecursive(grandChild, partToHighlight));
  return /*#__PURE__*/_react.default.cloneElement(child, {
    children: highlightedChildren
  });
}