"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _input = _interopRequireDefault(require("../../__internal__/input/input.style"));
var _inputIconToggle = _interopRequireDefault(require("../../__internal__/input-icon-toggle/input-icon-toggle.style"));
var _themes = require("../../style/themes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSelect = _styledComponents.default.div`
  ${({
  hasTextCursor,
  disabled,
  readOnly,
  theme,
  transparent,
  isOpen
}) => (0, _styledComponents.css)`
    ${_styledSystem.margin}

    position: relative;

    ${_input.default} {
      cursor: text;

      ${disabled && (0, _styledComponents.css)`
        cursor: not-allowed;
        color: var(--colorsUtilityYin030);
        text-shadow: none;
      `}

      ${readOnly && (0, _styledComponents.css)`
        cursor: ${hasTextCursor ? "text" : "default"};
        color: var(--colorsActionMinorYin090);
        text-shadow: none;
      `}
    }

    ${_inputPresentation.default} {
      cursor: ${hasTextCursor ? "text" : "pointer"};
      padding-right: 0;

      ${isOpen && (0, _styledComponents.css)`
        z-index: ${theme.zIndex.aboveAll};
      `}

      ${disabled && (0, _styledComponents.css)`
        cursor: not-allowed;
      `}

      ${readOnly && (0, _styledComponents.css)`
        cursor: ${hasTextCursor ? "text" : "default"};
      `}
    }

    ${_inputIconToggle.default} {
      margin-right: 0;
    }

    ${transparent && (0, _styledComponents.css)`
      ${_inputPresentation.default} {
        background: transparent;
        border: none;
      }

      ${_inputIconToggle.default} {
        margin-left: 0;
      }
    `}

    ${!hasTextCursor && (0, _styledComponents.css)`
      ${_input.default} {
        position: absolute;
        width: inherit;
        opacity: 0;
        padding: 0;
      }
    `}
  `}
`;
StyledSelect.defaultProps = {
  size: "medium",
  theme: _themes.baseTheme
};
var _default = exports.default = StyledSelect;