"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSelectLoaderContainer = exports.StyledSelectListTableHeader = exports.StyledSelectListTableBody = exports.StyledSelectListTable = exports.StyledSelectListContainer = exports.StyledSelectList = exports.StyledScrollableContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _themes = require("../../../style/themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSelectList = exports.StyledSelectList = _styledComponents.default.ul`
  ${({
  listHeight
}) => (0, _styledComponents.css)`
    box-sizing: border-box;
    display: flex;
    align-items: flex-start;
    flex-direction: column;
    list-style-type: none;
    margin: 0;
    outline: none;
    padding: 0;
    position: relative;
    width: 100%;
    ${listHeight === undefined ? "" : `height: ${listHeight}px;`}
  `}
`;
const StyledSelectLoaderContainer = exports.StyledSelectLoaderContainer = _styledComponents.default.div`
  display: flex;
  align-items: center;
  justify-content: center;
  padding-top: 24px;
  padding-bottom: 24px;
  width: 100%;
  flex-grow: 1;
`;
const StyledSelectListTable = exports.StyledSelectListTable = _styledComponents.default.table`
  background-color: var(--colorsUtilityYang100);
  border-collapse: collapse;
  border-radius: 0px;
  border-spacing: 0;
  min-width: 100%;
  white-space: nowrap;
  height: 180px;
  overflow-y: auto;

  thead,
  tr {
    display: table;
    width: 100%;
    table-layout: fixed;
  }
`;
// TODO (design-tokens): to match current style for border bottom colorsUtilityMajor100
const StyledSelectListTableHeader = exports.StyledSelectListTableHeader = _styledComponents.default.thead`
  border-bottom: 1px solid var(--colorsUtilityMajor050);
  position: sticky;
  top: 0;
  left: 0;
  z-index: 1;

  tr {
    width: ${({
  scrollbarWidth
}) => `calc(100% - ${scrollbarWidth}px)`};
  }

  th {
    position: sticky;
    top: 0;
    padding: var(--spacing200);
    background-color: white;
    text-align: left;
    font-weight: 900;
    font-size: 12px;
    text-transform: uppercase;
    color: var(--colorsUtilityYin055);
    :after {
      content: "";
      display: block;
      position: absolute;
      bottom: -8px;
      left: 0px;
      background-image: linear-gradient(
        var(--colorsUtilityMajor800),
        var(--colorsUtilityYang100)
      );
      opacity: 0.03;
      height: 8px;
      width: 100%;
    }
  }
`;
const StyledSelectListTableBody = exports.StyledSelectListTableBody = _styledComponents.default.tbody`
  display: block;
  width: 100%;
  table-layout: fixed;
  width: 100%;
  height: ${({
  listHeight
}) => `${listHeight}px`};
`;
const StyledSelectListContainer = exports.StyledSelectListContainer = _styledComponents.default.div`
  background-color: white;
  box-shadow: var(--boxShadow100);
  animation: fadeIn 250ms ease-out;
  position: absolute;
  z-index: ${({
  theme
}) => theme.zIndex.popover};
  display: flex;
  flex-wrap: wrap;
  align-items: flex-start;
  border-radius: var(--borderRadius050);
  ${({
  isLoading
}) => isLoading && "min-height: 150px"};

  @keyframes fadeIn {
    0% {
      opacity: 0;
    }
    100% {
      opacity: 1;
    }
  }
`;
const StyledScrollableContainer = exports.StyledScrollableContainer = _styledComponents.default.div`
  max-height: ${({
  maxHeight
}) => `${maxHeight}px`};
  width: 100%;
  border-top-left-radius: var(--borderRadius050);
  border-top-right-radius: var(--borderRadius050);
  overflow-y: auto;

  ${({
  hasActionButton
}) => !hasActionButton && (0, _styledComponents.css)`
      border-bottom-left-radius: var(--borderRadius050);
      border-bottom-right-radius: var(--borderRadius050);
    `}
`;
StyledSelectListContainer.defaultProps = {
  theme: _themes.baseTheme
};