"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("@floating-ui/dom");
var _reactVirtual = require("@tanstack/react-virtual");
var _findLastIndex = _interopRequireDefault(require("lodash/findLastIndex"));
var _usePrevious = _interopRequireDefault(require("../../../hooks/__internal__/usePrevious"));
var _useScrollBlock = _interopRequireDefault(require("../../../hooks/__internal__/useScrollBlock"));
var _useModalManager = _interopRequireDefault(require("../../../hooks/__internal__/useModalManager"));
var _selectList = require("./select-list.style");
var _popover = _interopRequireDefault(require("../../../__internal__/popover"));
var _optionRow = _interopRequireDefault(require("../option-row/option-row.component"));
var _getNextChildByText = _interopRequireDefault(require("../utils/get-next-child-by-text"));
var _getNextIndexByKey = _interopRequireDefault(require("../utils/get-next-index-by-key"));
var _isNavigationKey = _interopRequireDefault(require("../utils/is-navigation-key"));
var _listActionButton = _interopRequireDefault(require("../list-action-button"));
var _loader = _interopRequireDefault(require("../../loader"));
var _option = _interopRequireDefault(require("../option"));
var _selectListContext = _interopRequireDefault(require("../__internal__/select-list-context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TABLE_HEADER_HEIGHT = 48;
const SCROLL_OPTIONS = {
  behavior: "auto",
  align: "end"
};
const SelectList = /*#__PURE__*/_react.default.forwardRef(({
  listMaxHeight = 180,
  listActionButton,
  id,
  labelId,
  children,
  onSelect,
  onSelectListClose,
  filterText,
  anchorElement,
  highlightedValue,
  onListAction,
  isLoading,
  onListScrollBottom,
  multiColumn,
  tableHeader,
  loaderDataRole,
  listPlacement = "bottom",
  flipEnabled = true,
  isOpen,
  multiselectValues,
  enableVirtualScroll,
  virtualScrollOverscan = 5,
  ...listProps
}, listContainerRef) => {
  const [currentOptionsListIndex, setCurrentOptionsListIndex] = (0, _react.useState)(-1);
  const [scrollbarWidth, setScrollbarWidth] = (0, _react.useState)(0);
  const lastFilter = (0, _react.useRef)("");
  const listRef = (0, _react.useRef)(null);
  const tableRef = (0, _react.useRef)(null);
  const listActionButtonRef = (0, _react.useRef)(null);
  const {
    blockScroll,
    allowScroll
  } = (0, _useScrollBlock.default)();
  const actionButtonHeight = (0, _react.useRef)(0);
  const wasOpen = (0, _usePrevious.default)(isOpen);

  // ensure scroll-position goes back to the top whenever the list is (re)-opened. (On Safari, without this it remains at the bottom if it had been scrolled
  // to the bottom before closing.)
  (0, _react.useEffect)(() => {
    if (isOpen && !wasOpen && typeof listContainerRef.current?.scrollTo === 'function') {
      listContainerRef.current.scrollTo(0, 0);
    }
  });
  const overscan = enableVirtualScroll ? virtualScrollOverscan : _react.default.Children.count(children);

  // need to use a custom rangeExtractor that ensure the currently-selected option, if any, always appears as an option returned from the virtualiser.
  // This ensures that the aria-activedescendant value is always valid even when the currently-selected item is out of the visible range.
  const rangeExtractor = range => {
    const toRender = (0, _reactVirtual.defaultRangeExtractor)(range);
    if (currentOptionsListIndex !== -1 && !toRender.includes(currentOptionsListIndex)) {
      toRender.push(currentOptionsListIndex);
    }
    return toRender;
  };
  const virtualizer = (0, _reactVirtual.useVirtualizer)({
    count: _react.default.Children.count(children),
    getScrollElement: () => listContainerRef.current,
    estimateSize: () => 40,
    // value doesn't really seem to matter since we're dynamically measuring, but 40px is the height of a single-line option
    overscan,
    paddingStart: multiColumn ? TABLE_HEADER_HEIGHT : 0,
    scrollPaddingEnd: actionButtonHeight.current,
    rangeExtractor
  });
  const items = virtualizer.getVirtualItems();
  const childrenList = (0, _react.useMemo)(() => _react.default.Children.toArray(children), [children]);

  // check if object values are equal
  function shallowEqual(objA, objB) {
    const keysA = Object.keys(objA);
    return keysA.every(key => objA[key] === objB[key]);
  }
  const getIndexOfMatch = (0, _react.useCallback)(valueToMatch => {
    return childrenList.findIndex(child => {
      if (child.props.value && typeof valueToMatch === "object") {
        return shallowEqual(child.props.value, valueToMatch);
      }
      return /*#__PURE__*/_react.default.isValidElement(child) && child.props.value === valueToMatch;
    });
  }, [childrenList]);

  // getVirtualItems returns an empty array of items if the select list is currently closed - which is correct visually but
  // we need to ensure that any currently-selected option is still in the DOM to avoid any accessibility issues.
  // The isOpen prop will ensure that no options are visible regardless of what is in the items array.
  if (items.length === 0) {
    const currentIndex = highlightedValue ? getIndexOfMatch(highlightedValue) : currentOptionsListIndex;
    if (currentIndex > -1) {
      // only index property is required with the item not visible so the following type assertion, even though incorrect,
      // should be OK
      items.push({
        index: currentIndex
      });
    }
  }
  const listHeight = virtualizer.getTotalSize();
  (0, _react.useEffect)(() => {
    if (isOpen) {
      blockScroll();
    }
    return () => {
      if (isOpen) {
        allowScroll();
      }
    };
  }, [allowScroll, blockScroll, isOpen]);
  (0, _react.useLayoutEffect)(() => {
    if (multiColumn) {
      setScrollbarWidth(tableRef.current ? tableRef.current.offsetWidth - tableRef.current.clientWidth : /* istanbul ignore next */0);
    }
  }, [multiColumn]);
  const anchorRef = (0, _react.useMemo)(() => ({
    current: anchorElement || null
  }), [anchorElement]);
  const handleSelect = (0, _react.useCallback)(optionData => {
    onSelect({
      ...optionData,
      selectionType: "click",
      selectionConfirmed: true
    });
  }, [onSelect]);
  const childElementRefs = (0, _react.useRef)(Array.from({
    length: _react.default.Children.count(children)
  }));
  const optionChildrenList = (0, _react.useMemo)(() => childrenList.filter(child => /*#__PURE__*/_react.default.isValidElement(child) && (child.type === _option.default || child.type === _optionRow.default)), [childrenList]);
  const {
    measureElement
  } = virtualizer;
  const measureCallback = element => {
    // need a guard to prevent crash with too many rerenders when closing the list
    if (isOpen) {
      measureElement(element);
    }
  };

  // the rangeExtractor above can cause an undefined value to be appended to the return items.
  // Easiest way to stop that crashing is just to filter it out.
  const renderedChildren = items.filter(item => item !== undefined).map(({
    index,
    start
  }) => {
    const child = childrenList[index];
    if (! /*#__PURE__*/_react.default.isValidElement(child)) {
      return child;
    }
    const optionChildIndex = optionChildrenList.indexOf(child);
    const isOption = optionChildIndex > -1;
    const newProps = {
      index,
      onSelect: handleSelect,
      hidden: isLoading && childrenList.length === 1,
      // these need to be inline styles rather than implemented in styled-components to avoid it generating thousands of classes
      style: {
        transform: `translateY(${start}px)`
      },
      "aria-setsize": isOption ? optionChildrenList.length : undefined,
      "aria-posinset": isOption ? optionChildIndex + 1 : undefined,
      ref: optionElement => {
        // needed to dynamically compute the size
        measureCallback(optionElement);
        // add the DOM element to the array of refs
        childElementRefs.current[index] = optionElement;
      },
      "data-index": index
    };
    return /*#__PURE__*/_react.default.cloneElement(child, newProps);
  });
  const lastOptionIndex = (0, _findLastIndex.default)(childrenList, child => /*#__PURE__*/_react.default.isValidElement(child) && (child.type === _option.default || child.type === _optionRow.default));
  const getNextHighlightableItemIndex = (0, _react.useCallback)((key, indexOfHighlighted) => {
    const lastIndex = lastOptionIndex;
    if (lastIndex === -1) {
      return -1;
    }
    let nextIndex = (0, _getNextIndexByKey.default)(key, indexOfHighlighted, lastIndex, isLoading);
    const nextElement = childrenList[nextIndex];
    if ( /*#__PURE__*/_react.default.isValidElement(nextElement) && nextElement.type !== _option.default && nextElement.type !== _optionRow.default || nextElement.props.disabled) {
      nextIndex = getNextHighlightableItemIndex(key, nextIndex);
    }
    return nextIndex;
  }, [childrenList, lastOptionIndex, isLoading]);
  const highlightNextItem = (0, _react.useCallback)(key => {
    let currentIndex = currentOptionsListIndex;
    if (highlightedValue) {
      const indexOfHighlighted = getIndexOfMatch(highlightedValue);
      currentIndex = indexOfHighlighted;
    }
    const nextIndex = getNextHighlightableItemIndex(key, currentIndex);
    if (nextIndex === -1 || currentIndex === nextIndex) {
      return;
    }
    const {
      text,
      value
    } = childrenList[nextIndex].props;
    onSelect({
      text,
      value,
      selectionType: "navigationKey",
      id: childElementRefs.current[nextIndex]?.id,
      selectionConfirmed: false
    });
  }, [childrenList, currentOptionsListIndex, getIndexOfMatch, getNextHighlightableItemIndex, highlightedValue, onSelect]);
  const handleActionButtonTab = (0, _react.useCallback)((event, isActionButtonFocused) => {
    if (isActionButtonFocused) {
      onSelect({
        selectionType: "tab",
        selectionConfirmed: false
      });
    } else {
      event.preventDefault();
      listActionButtonRef.current?.focus();
    }
  }, [onSelect]);
  const focusOnAnchor = (0, _react.useCallback)(() => {
    if (anchorElement) {
      anchorElement.getElementsByTagName("input")[0].focus();
    }
  }, [anchorElement]);
  const handleGlobalKeydown = (0, _react.useCallback)(event => {
    if (!isOpen) {
      return;
    }
    const {
      key
    } = event;
    const isActionButtonFocused = document.activeElement === listActionButtonRef.current;
    if (key === "Tab" && listActionButton) {
      handleActionButtonTab(event, isActionButtonFocused);
    } else if (key === "Tab") {
      onSelectListClose();
    } else if (key === "Enter" && !isActionButtonFocused) {
      event.preventDefault();
      const currentOption = childrenList[currentOptionsListIndex];
      if (! /*#__PURE__*/_react.default.isValidElement(currentOption)) {
        onSelectListClose();

        // need to call onSelect here with empty text/value to clear the input when
        // no matches found in FilterableSelect
        onSelect({
          id: undefined,
          text: "",
          value: "",
          selectionType: "enterKey",
          selectionConfirmed: false
        });
        return;
      }
      if (currentOption.props.disabled) {
        return;
      }
      const {
        text,
        value
      } = currentOption.props;
      onSelect({
        id: childElementRefs.current[currentOptionsListIndex]?.id,
        text,
        value,
        selectionType: "enterKey",
        selectionConfirmed: true
      });
    } else if ((0, _isNavigationKey.default)(key)) {
      focusOnAnchor();
      highlightNextItem(key);
    }
  }, [childrenList, listActionButton, handleActionButtonTab, onSelectListClose, currentOptionsListIndex, onSelect, highlightNextItem, focusOnAnchor, isOpen]);
  const handleEscapeKey = (0, _react.useCallback)(event => {
    if (event.key === "Escape") {
      onSelectListClose();
    }
  }, [onSelectListClose]);
  (0, _useModalManager.default)({
    open: !!isOpen,
    closeModal: handleEscapeKey,
    modalRef: listRef,
    triggerRefocusOnClose: false
  });
  const handleListScroll = (0, _react.useCallback)(event => {
    const element = event.target;

    /* istanbul ignore else */
    if (isOpen && onListScrollBottom && element.scrollHeight - element.scrollTop === element.clientHeight) {
      onListScrollBottom();
    }
  }, [onListScrollBottom, isOpen]);
  (0, _react.useEffect)(() => {
    const keyboardEvent = "keydown";
    const listElement = listContainerRef.current;
    window.addEventListener(keyboardEvent, handleGlobalKeydown);
    listElement?.addEventListener("scroll", handleListScroll);
    return function cleanup() {
      window.removeEventListener(keyboardEvent, handleGlobalKeydown);
      listElement?.removeEventListener("scroll", handleListScroll);
    };
  }, [handleGlobalKeydown, handleListScroll, listContainerRef]);
  (0, _react.useEffect)(() => {
    if (!filterText || filterText === lastFilter.current) {
      lastFilter.current = filterText || "";
      return;
    }
    lastFilter.current = filterText;
    setCurrentOptionsListIndex(previousIndex => {
      const match = (0, _getNextChildByText.default)(filterText, childrenList, previousIndex);
      if (!match) {
        return -1;
      }
      const indexOfMatch = getIndexOfMatch(match.props.value);
      virtualizer.scrollToIndex(indexOfMatch, SCROLL_OPTIONS);
      return indexOfMatch;
    });
  }, [childrenList, filterText, getIndexOfMatch, virtualizer]);
  (0, _react.useEffect)(() => {
    // remove the current selected option if the value is cleared
    // this prevents it from remaining highlighted when the list is re-opened
    if ((!highlightedValue || Object.keys(highlightedValue).length === 0) && !isOpen) {
      setCurrentOptionsListIndex(-1);
      return;
    }
    const indexOfMatch = getIndexOfMatch(highlightedValue);
    if (indexOfMatch === -1) {
      return;
    }
    setCurrentOptionsListIndex(indexOfMatch);
  }, [getIndexOfMatch, highlightedValue, isOpen]);

  // ensure that the currently-selected option is always visible immediately after
  // it has been changed
  (0, _react.useEffect)(() => {
    if (currentOptionsListIndex > -1) {
      virtualizer.scrollToIndex(currentOptionsListIndex, SCROLL_OPTIONS);
    }
  }, [currentOptionsListIndex, virtualizer]);
  (0, _react.useEffect)(() => {
    if (isLoading && currentOptionsListIndex === lastOptionIndex && lastOptionIndex > -1) {
      virtualizer.scrollToIndex(lastOptionIndex, {
        ...SCROLL_OPTIONS,
        align: "start"
      });
    }
  }, [children, currentOptionsListIndex, isLoading, lastOptionIndex, listContainerRef, virtualizer]);
  const popoverMiddleware = (0, _react.useMemo)(() => [(0, _dom.offset)(3), (0, _dom.size)({
    apply({
      rects,
      elements
    }) {
      Object.assign(elements.floating.style, {
        width: `${rects.reference.width}px`
      });
    }
  }), ...(flipEnabled ? [(0, _dom.flip)({
    fallbackStrategy: "initialPlacement"
  })] : [])], [flipEnabled]);
  const loader = isLoading ? /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectLoaderContainer, {
    key: "loader"
  }, /*#__PURE__*/_react.default.createElement(_loader.default, {
    "data-role": loaderDataRole
  })) : undefined;
  let selectListContent = renderedChildren;
  const listBoxProps = {
    role: "listbox",
    id,
    "aria-labelledby": labelId,
    "aria-multiselectable": multiselectValues ? true : undefined
  };
  (0, _react.useLayoutEffect)(() => {
    if (listActionButton && isOpen) {
      actionButtonHeight.current = listActionButtonRef.current?.parentElement?.offsetHeight || 0;
    }
  }, [listActionButton, isOpen]);
  if (multiColumn) {
    selectListContent = /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectListTable, null, /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectListTableHeader, {
      scrollbarWidth: scrollbarWidth
    }, tableHeader), /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectListTableBody, _extends({}, listBoxProps, {
      "aria-labelledby": labelId,
      ref: tableRef,
      listHeight: listHeight - TABLE_HEADER_HEIGHT
    }), renderedChildren));
  }
  return /*#__PURE__*/_react.default.createElement(_selectListContext.default.Provider, {
    value: {
      currentOptionsListIndex,
      multiselectValues
    }
  }, /*#__PURE__*/_react.default.createElement(_popover.default, {
    placement: listPlacement,
    disablePortal: true,
    reference: anchorRef,
    middleware: popoverMiddleware,
    isOpen: isOpen,
    disableBackgroundUI: true,
    animationFrame: true
  }, /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectListContainer, _extends({
    "data-element": "select-list-wrapper",
    isLoading: isLoading
  }, listProps), /*#__PURE__*/_react.default.createElement(_selectList.StyledScrollableContainer, {
    ref: listContainerRef,
    maxHeight: listMaxHeight,
    "data-component": "select-list-scrollable-container",
    hasActionButton: !!listActionButton
  }, /*#__PURE__*/_react.default.createElement(_selectList.StyledSelectList, _extends({
    as: multiColumn ? "div" : "ul",
    "data-element": "select-list"
  }, multiColumn ? {} : listBoxProps, {
    ref: listRef,
    tabIndex: -1,
    listHeight: multiColumn ? undefined : listHeight
  }), selectListContent), loader), listActionButton && /*#__PURE__*/_react.default.createElement(_listActionButton.default, {
    ref: listActionButtonRef,
    listActionButton: listActionButton,
    onListAction: onListAction
  }))));
});
if (process.env.NODE_ENV !== "production") {
  SelectList.propTypes = {
    "anchorElement": function (props, propName) {
      if (props[propName] == null) {
        return null;
      } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
        return new Error("Expected prop '" + propName + "' to be of type Element");
      }
    },
    "children": _propTypes.default.node,
    "enableVirtualScroll": _propTypes.default.bool,
    "filterText": _propTypes.default.string,
    "flipEnabled": _propTypes.default.bool,
    "highlightedValue": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
    "id": _propTypes.default.string,
    "isLoading": _propTypes.default.bool,
    "isOpen": _propTypes.default.bool,
    "labelId": _propTypes.default.string,
    "listActionButton": _propTypes.default.node,
    "listMaxHeight": _propTypes.default.number,
    "listPlacement": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "loaderDataRole": _propTypes.default.string,
    "multiColumn": _propTypes.default.bool,
    "multiselectValues": _propTypes.default.arrayOf(_propTypes.default.string),
    "onListAction": _propTypes.default.func,
    "onListScrollBottom": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "onSelect": _propTypes.default.func.isRequired,
    "onSelectListClose": _propTypes.default.func.isRequired,
    "tableHeader": _propTypes.default.node,
    "virtualScrollOverscan": _propTypes.default.number
  };
}
var _default = exports.default = SelectList;