"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _optionRow = _interopRequireDefault(require("./option-row.style"));
var _selectListContext = _interopRequireDefault(require("../__internal__/select-list-context"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const OptionRow = /*#__PURE__*/_react.default.forwardRef(({
  id,
  text,
  children,
  disabled,
  onSelect,
  value,
  index,
  hidden,
  style,
  ...rest
}, ref) => {
  const internalIdRef = (0, _react.useRef)(id || (0, _guid.default)());
  const handleClick = () => {
    if (disabled) {
      return;
    }
    onSelect?.({
      text,
      value,
      id: internalIdRef.current
    });
  };
  const selectListContext = (0, _react.useContext)(_selectListContext.default);
  let isSelected = selectListContext.currentOptionsListIndex === index;
  if (selectListContext.multiselectValues) {
    isSelected = selectListContext.multiselectValues.includes(value);
  }
  return /*#__PURE__*/_react.default.createElement(_optionRow.default, _extends({
    id: internalIdRef.current,
    ref: ref,
    "aria-selected": isSelected,
    "aria-disabled": disabled,
    "data-component": "option-row",
    isDisabled: disabled,
    onClick: handleClick,
    isHighlighted: selectListContext.currentOptionsListIndex === index,
    role: "option",
    hidden: hidden,
    style: style
  }, rest), children);
});
if (process.env.NODE_ENV !== "production") {
  OptionRow.propTypes = {
    "children": _propTypes.default.node,
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "hidden": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "index": _propTypes.default.number,
    "onSelect": _propTypes.default.func,
    "style": _propTypes.default.object,
    "text": _propTypes.default.string.isRequired,
    "value": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]).isRequired
  };
}
OptionRow.displayName = "OptionRow";
var _default = exports.default = OptionRow;