import React from "react";
import { CSSProperties } from "styled-components";
import { TagProps } from "__internal__/utils/helpers/tags";
export interface OptionRowProps extends TagProps {
    /** The option's visible text, displayed within <Textbox> of <Select> */
    text: string;
    /** Row content, should consist of multiple td elements */
    children: React.ReactNode;
    /** The option's invisible internal value */
    value: string | Record<string, unknown>;
    /**
     * Unique identifier for the component.
     * Will use a randomly generated GUID if none is provided.
     */
    id?: string;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /**
     * @private
     * @ignore
     * Callback to return value when the element is selected (prop added by the SelectList component) */
    onSelect?: (ev: {
        id?: string;
        text: string;
        value: string | Record<string, unknown>;
    }) => void;
    /**
     * @private
     * @ignore
     * Position of the element in the list */
    index?: number;
    /**
     * @private
     * @ignore
     * True when option should be hidden from the view (prop added by the SelectList component) */
    hidden?: boolean;
    /**
     * @private
     * @ignore
     * object containing CSS styles to be passed to the underlying DOM element */
    style?: CSSProperties;
}
declare const OptionRow: React.ForwardRefExoticComponent<OptionRowProps & React.RefAttributes<HTMLTableRowElement>>;
export default OptionRow;
