"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSelectPillContainer = exports.StyledSelectMultiSelect = exports.StyledAccessibilityLabelContainer = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _pill = _interopRequireDefault(require("../../pill/pill.style"));
var _themes = require("../../../style/themes");
var _inputIconToggle = _interopRequireDefault(require("../../../__internal__/input-icon-toggle/input-icon-toggle.style"));
var _select = _interopRequireDefault(require("../select.style"));
var _inputPresentation = _interopRequireDefault(require("../../../__internal__/input/input-presentation.style"));
var _input = _interopRequireDefault(require("../../../__internal__/input/input.style"));
var _inputSizes = _interopRequireDefault(require("../../../__internal__/input/input-sizes.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const StyledSelectPillContainer = exports.StyledSelectPillContainer = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  justify-content: center;
  margin: 3px 2px 3px 0;
  max-width: 100%;

  && ${_pill.default} {
    text-overflow: ellipsis;
  }
`;
const StyledSelectMultiSelect = exports.StyledSelectMultiSelect = (0, _styledComponents.default)(_select.default)`
  ${_inputIconToggle.default} {
    position: absolute;
    right: 0;
    height: 100%;
  }

  ${_inputPresentation.default} {
    // size has a default value of "medium" defined in StyledSelect, but TS can't see this
    padding-right: ${({
  size
}) => _inputSizes.default[size].height};
    padding-left: ${({
  size
}) => _inputSizes.default[size].horizontalPadding};
    position: relative;

    ${_input.default} {
      padding: 0;
    }
  }
`;
const StyledAccessibilityLabelContainer = exports.StyledAccessibilityLabelContainer = _styledComponents.default.div`
  display: none;
`;
StyledSelectPillContainer.defaultProps = {
  theme: _themes.baseTheme
};