import React from "react";
import { Side } from "@floating-ui/dom";
import { FormInputPropTypes } from "../select-textbox";
export interface MultiSelectProps extends Omit<FormInputPropTypes, "defaultValue" | "value"> {
    /** Prop to specify the aria-label attribute of the component input */
    "aria-label"?: string;
    /** Prop to specify the aria-labeledby property of the component input */
    "aria-labelledby"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Size of an input */
    size?: "small" | "medium" | "large";
    /** Child components (such as Option or OptionRow) for the SelectList */
    children: React.ReactNode;
    /** The default selected value(s), when the component is operating in uncontrolled mode */
    defaultValue?: string[] | Record<string, unknown>[];
    /** If true the loader animation is displayed in the option list */
    isLoading?: boolean;
    /** When true component will work in multi column mode.
     * Children should consist of OptionRow components in this mode
     */
    multiColumn?: boolean;
    /** A custom message to be displayed when any option does not match the filter text */
    noResultsMessage?: string;
    /** A custom callback for when the input text changes */
    onFilterChange?: (filterText: string) => void;
    /** A custom callback for when the dropdown menu opens */
    onOpen?: () => void;
    /** If true the Component opens on focus */
    openOnFocus?: boolean;
    /** SelectList table header, should consist of multiple th elements.
     * Works only in multiColumn mode
     */
    tableHeader?: React.ReactNode;
    /** The selected value(s), when the component is operating in controlled mode */
    value?: string[] | Record<string, unknown>[];
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Maximum list height - defaults to 180 */
    listMaxHeight?: number;
    /** Placement of the select list in relation to the input element */
    listPlacement?: Side;
    /** Use the opposite list placement if the set placement does not fit */
    flipEnabled?: boolean;
    /** Wraps the pill text when it would overflow the input width */
    wrapPillText?: boolean;
    /** Set this prop to enable a virtualised list of options. If it is not used then all options will be in the
     * DOM at all times, which may cause performance problems on very large lists */
    enableVirtualScroll?: boolean;
    /** The number of options to render into the DOM at once, either side of the currently-visible ones.
     * Higher values make for smoother scrolling but may impact performance.
     * Only used if the `enableVirtualScroll` prop is set. */
    virtualScrollOverscan?: number;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
}
export declare const MultiSelect: React.ForwardRefExoticComponent<MultiSelectProps & React.RefAttributes<unknown>>;
export default MultiSelect;
