"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _listActionButton = _interopRequireDefault(require("./list-action-button.style"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
var _button = _interopRequireDefault(require("../../button"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const ListActionButton = /*#__PURE__*/_react.default.forwardRef(({
  listActionButton,
  onListAction
}, ref) => {
  const l = (0, _useLocale.default)();
  function renderListActionButton() {
    if (!listActionButton || listActionButton === true) {
      return /*#__PURE__*/_react.default.createElement(_button.default, {
        ref: ref,
        onClick: onListAction,
        iconType: "add",
        iconPosition: "after"
      }, l.select.actionButtonText());
    }

    // istanbul ignore if
    if (! /*#__PURE__*/_react.default.isValidElement(listActionButton)) {
      return listActionButton;
    }
    return /*#__PURE__*/_react.default.cloneElement(listActionButton, {
      ref,
      onClick: onListAction
    });
  }
  return /*#__PURE__*/_react.default.createElement(_listActionButton.default, null, renderListActionButton());
});
if (process.env.NODE_ENV !== "production") {
  ListActionButton.propTypes = {
    "listActionButton": _propTypes.default.node,
    "onListAction": _propTypes.default.func
  };
}
ListActionButton.displayName = "ListActionButton";
var _default = exports.default = ListActionButton;