"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FilterableSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _utils = require("../../../style/utils");
var _selectTextbox = _interopRequireDefault(require("../select-textbox"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _withFilter = _interopRequireDefault(require("../utils/with-filter.hoc"));
var _select = _interopRequireDefault(require("../select.style"));
var _selectList = _interopRequireDefault(require("../select-list/select-list.component"));
var _isExpectedOption = _interopRequireDefault(require("../utils/is-expected-option"));
var _isNavigationKey = _interopRequireDefault(require("../utils/is-navigation-key"));
var _logger = _interopRequireDefault(require("../../../__internal__/utils/logger"));
var _useStableCallback = _interopRequireDefault(require("../../../hooks/__internal__/useStableCallback"));
var _useFormSpacing = _interopRequireDefault(require("../../../hooks/__internal__/useFormSpacing"));
var _useInputAccessibility = _interopRequireDefault(require("../../../hooks/__internal__/useInputAccessibility/useInputAccessibility"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const FilterableSelectList = (0, _withFilter.default)(_selectList.default);
const FilterableSelect = exports.FilterableSelect = /*#__PURE__*/_react.default.forwardRef(({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledby,
  value,
  defaultValue,
  id,
  name,
  label,
  children,
  onOpen: onOpenProp,
  onChange,
  onFilterChange: onFilterChangeProp,
  onClick,
  onKeyDown,
  onFocus,
  onBlur,
  openOnFocus,
  noResultsMessage,
  listActionButton,
  listMaxHeight,
  onListAction,
  isLoading,
  disabled,
  readOnly,
  onListScrollBottom,
  tableHeader,
  multiColumn,
  "data-component": dataComponent = "filterable-select",
  "data-element": dataElement,
  "data-role": dataRole,
  tooltipPosition,
  listPlacement = "bottom",
  flipEnabled = true,
  enableVirtualScroll,
  virtualScrollOverscan,
  disableDefaultFiltering = false,
  isOptional,
  required,
  ...textboxProps
}, ref) => {
  const [activeDescendantId, setActiveDescendantId] = (0, _react.useState)();
  const selectListId = (0, _react.useRef)((0, _guid.default)());
  const containerRef = (0, _react.useRef)(null);
  const listboxRef = (0, _react.useRef)(null);
  const isControlled = (0, _react.useRef)(value !== undefined);
  const isMouseDownReported = (0, _react.useRef)(false);
  const isInputFocused = (0, _react.useRef)(false);
  const isMouseDownOnInput = (0, _react.useRef)(false);
  const [textboxRef, setTextboxRef] = (0, _react.useState)();
  const [isOpen, setOpen] = (0, _react.useState)(false);
  const [textValue, setTextValue] = (0, _react.useState)("");
  const [selectedValue, setSelectedValue] = (0, _react.useState)(value || defaultValue || "");
  const [highlightedValue, setHighlightedValue] = (0, _react.useState)("");
  const [filterText, setFilterText] = (0, _react.useState)("");
  const inputId = (0, _react.useRef)(id || (0, _guid.default)());
  const {
    labelId
  } = (0, _useInputAccessibility.default)({
    id: inputId.current,
    label
  });
  const focusTimer = (0, _react.useRef)(null);
  const openOnFocusFlagBlock = (0, _react.useRef)(false);
  const componentIsUncontrolled = !isControlled || !onChange && defaultValue;
  if (!deprecateUncontrolledWarnTriggered && componentIsUncontrolled) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Filterable Select` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  const createCustomEvent = (0, _react.useCallback)((newValue, selectionConfirmed) => {
    const customEvent = {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: newValue
      },
      selectionConfirmed
    };
    return customEvent;
  }, [name, id]);
  const triggerChange = (0, _react.useCallback)((newValue, selectionConfirmed) => {
    if (onChange) {
      onChange(createCustomEvent(newValue, selectionConfirmed));
    }
  }, [onChange, createCustomEvent]);
  function findElementWithMatchingText(textToMatch, list) {
    return _react.default.Children.toArray(list).find(child => {
      const {
        text
      } = child.props;
      return text?.toLowerCase().indexOf(textToMatch?.toLowerCase()) !== -1;
    });
  }
  const updateValues = (0, _react.useCallback)((newFilterText, isDeleteEvent) => {
    setSelectedValue(previousValue => {
      const trimmed = newFilterText.trimStart();
      const match = findElementWithMatchingText(trimmed, children);
      const isFilterCleared = isDeleteEvent && !newFilterText.length;
      if (!match || isFilterCleared || match.props.disabled) {
        setTextValue(newFilterText);
        triggerChange("", false);
        return "";
      }
      if (trimmed.length) {
        triggerChange(match.props.value, false);
      }
      if (isDeleteEvent) {
        setTextValue(newFilterText);
        return match.props.value;
      }
      if (trimmed.length && match.props.text?.toLowerCase().startsWith(trimmed.toLowerCase())) {
        setTextValue(match.props.text);
      } else {
        setTextValue(newFilterText);
      }
      if (isControlled.current) {
        return previousValue;
      }
      setHighlightedValue(match.props.value);
      return match.props.value;
    });
  }, [children, triggerChange]);
  const setMatchingText = (0, _react.useCallback)((newValue, isClosing = false) => {
    const matchingOption = _react.default.Children.toArray(children).find(child => /*#__PURE__*/_react.default.isValidElement(child) && (0, _isExpectedOption.default)(child, newValue));
    if (!matchingOption || matchingOption.props.text === undefined) {
      setTextValue(filterText || "");
    } else if (isClosing || matchingOption.props.text?.toLowerCase().startsWith(filterText?.toLowerCase().trim())) {
      setTextValue(matchingOption.props.text);
    }
  }, [children, filterText]);
  const handleTextboxChange = (0, _react.useCallback)(event => {
    const newValue = event.target.value;
    const isDeleteEvent = event.nativeEvent.inputType === "deleteContentBackward" || event.nativeEvent.inputType === "deleteContentForward" || event.nativeEvent.inputType === "delete";
    updateValues(newValue, isDeleteEvent);
    setFilterText(newValue);
    setOpen(true);
  }, [updateValues]);
  const fillLastFilterCharacter = (0, _react.useCallback)(key => {
    setFilterText(previousFilterText => {
      if (previousFilterText?.length === textValue?.length - 1 && key === textValue.slice(-1)) {
        return textValue;
      }
      return previousFilterText;
    });
  }, [textValue]);
  const handleTextboxKeydown = (0, _react.useCallback)(event => {
    const {
      key
    } = event;
    if (onKeyDown) {
      onKeyDown(event);
    }
    if (readOnly) {
      return;
    }
    if (!event.defaultPrevented && (0, _isNavigationKey.default)(key)) {
      event.preventDefault();
      setOpen(true);
    }
    fillLastFilterCharacter(key);
  }, [fillLastFilterCharacter, onKeyDown, readOnly]);
  const valueToUse = isControlled.current ? value : selectedValue;
  const handleGlobalClick = (0, _react.useCallback)(event => {
    const notInContainer = containerRef.current && !containerRef.current.contains(event.target);
    const notInList = listboxRef.current && !listboxRef.current.contains(event.target);
    isMouseDownReported.current = false;
    if (notInContainer && notInList) {
      setMatchingText(valueToUse, true);
      setOpen(false);
    }
  }, [setMatchingText, valueToUse]);
  (0, _react.useEffect)(() => {
    const modeSwitchedMessage = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    const onChangeMissingMessage = "onChange prop required when using a controlled input element";
    !(isControlled.current === (value !== undefined)) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, modeSwitchedMessage) : (0, _invariant.default)(false) : void 0;
    !(!isControlled.current || isControlled.current && onChange) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, onChangeMissingMessage) : (0, _invariant.default)(false) : void 0;
    if (isControlled.current) {
      setSelectedValue(prevValue => {
        if (value && prevValue !== value) {
          setMatchingText(value);
        }
        return value;
      });
      setHighlightedValue(value);
    } else {
      if (textValue !== selectedValue) {
        setMatchingText(selectedValue);
      }
      if (highlightedValue !== selectedValue) {
        setHighlightedValue(selectedValue);
      }
    }
    // prevent value update on filter change
    // selectedValue and highlightedValue omitted from deps, only want uncontrolled change if onChange/children update
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [value, onChange, children]);
  const onOpen = (0, _useStableCallback.default)(onOpenProp);
  (0, _react.useEffect)(() => {
    if (!isOpen) {
      setFilterText("");
    } else if (onOpen) {
      onOpen();
    }
  }, [onOpen, isOpen]);
  (0, _react.useEffect)(() => {
    const hasListActionButton = listActionButton !== undefined;
    const onListActionMissingMessage = "onListAction prop required when using listActionButton prop";
    !(!hasListActionButton || hasListActionButton && onListAction) ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, onListActionMissingMessage) : (0, _invariant.default)(false) : void 0;
  }, [listActionButton, onListAction]);
  (0, _react.useEffect)(() => {
    if (isControlled.current) {
      setMatchingText(value);
    }
    // update text value only when children are changing
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [value, children]);
  const onFilterChange = (0, _useStableCallback.default)(onFilterChangeProp);
  const isFirstRender = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    if (onFilterChange && !isFirstRender.current) {
      onFilterChange(filterText);
    }
  }, [onFilterChange, filterText]);
  (0, _react.useEffect)(() => {
    isFirstRender.current = false;
  }, []);
  (0, _react.useEffect)(() => {
    const clickEvent = "click";
    window.addEventListener(clickEvent, handleGlobalClick);
    return function cleanup() {
      window.removeEventListener(clickEvent, handleGlobalClick);
    };
  }, [handleGlobalClick]);
  (0, _react.useEffect)(() => {
    const trimmed = filterText?.trimStart();
    const textStartsWithFilter = textValue?.toLowerCase().startsWith(trimmed.toLowerCase());
    const isTextboxActive = !disabled && !readOnly;
    if (isTextboxActive && textboxRef && trimmed.length && textValue?.length > trimmed.length && textStartsWithFilter) {
      textboxRef.selectionStart = trimmed.length;
    }
  }, [textValue, filterText, textboxRef, disabled, readOnly]);
  const onSelectOption = (0, _react.useCallback)(optionData => {
    const {
      id: selectedOptionId,
      text,
      value: newValue = "",
      selectionType,
      selectionConfirmed
    } = optionData;
    if (selectionType === "tab") {
      setOpen(false);
      textboxRef?.focus();
      return;
    }
    if (!isControlled.current) {
      setSelectedValue(newValue);
      setHighlightedValue(newValue);
    }
    setTextValue(text || /* istanbul ignore next */"");
    triggerChange(newValue, !!selectionConfirmed);
    setActiveDescendantId(selectedOptionId);
    if (selectionType !== "navigationKey") {
      openOnFocusFlagBlock.current = !!openOnFocus;
      setOpen(false);
      textboxRef?.focus();
      textboxRef?.select();
      openOnFocusFlagBlock.current = false;
    }
  }, [textboxRef, triggerChange, openOnFocus]);
  const onSelectListClose = (0, _react.useCallback)(() => {
    setOpen(false);
    setMatchingText(selectedValue, true);
  }, [selectedValue, setMatchingText]);
  function handleTextboxClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
  }
  function handleDropdownIconClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
    setOpen(isAlreadyOpen => {
      return !isAlreadyOpen;
    });
  }
  function handleTextboxFocus(event) {
    const triggerFocus = () => onFocus?.(event);
    if (openOnFocus) {
      if (focusTimer.current) {
        clearTimeout(focusTimer.current);
      }
      if (openOnFocusFlagBlock.current) {
        return;
      }

      // we need to use a timeout here as there is a race condition when rendered in a modal
      // whereby the select list isn't visible when the select is auto focused straight away
      focusTimer.current = setTimeout(() => {
        setOpen(isAlreadyOpen => {
          if (isAlreadyOpen) {
            return true;
          }
          if (onFocus && !isInputFocused.current) {
            triggerFocus();
            isInputFocused.current = true;
          }
          if (isMouseDownReported.current && !isMouseDownOnInput.current) {
            return false;
          }
          return true;
        });
      });
    } else if (onFocus && !isInputFocused.current) {
      triggerFocus();
      isInputFocused.current = true;
    }
  }
  function handleTextboxBlur(event) {
    isMouseDownOnInput.current = false;
    if (isMouseDownReported.current) {
      return;
    }
    isInputFocused.current = false;
    if (onBlur) {
      onBlur(event);
    }
  }
  function handleTextboxMouseDown(event) {
    isMouseDownReported.current = true;
    if (event.target.dataset.element === "input") {
      isMouseDownOnInput.current = true;
    }
  }
  function handleListMouseDown() {
    isMouseDownReported.current = true;
  }
  function handleOnListAction() {
    setOpen(false);
    onListAction?.();
  }
  const assignInput = (0, _react.useCallback)(element => {
    setTextboxRef(element);
    if (!ref) {
      return;
    }
    if (typeof ref === "function") {
      ref(element);
    } else {
      ref.current = element;
    }
  }, [ref]);
  function getTextboxProps() {
    return {
      id: inputId.current,
      name,
      label,
      disabled,
      readOnly,
      ref: assignInput,
      selectedValue,
      formattedValue: textValue,
      onClick: handleTextboxClick,
      iconOnClick: handleDropdownIconClick,
      iconOnMouseDown: handleTextboxMouseDown,
      onFocus: handleTextboxFocus,
      onBlur: handleTextboxBlur,
      onKeyDown: handleTextboxKeydown,
      onChange: handleTextboxChange,
      onMouseDown: handleTextboxMouseDown,
      tooltipPosition,
      required,
      isOptional,
      ...(0, _utils.filterOutStyledSystemSpacingProps)(textboxProps)
    };
  }
  const selectListProps = {
    ref: listboxRef,
    id: selectListId.current,
    labelId,
    anchorElement: textboxRef?.parentElement || undefined,
    onSelect: onSelectOption,
    onSelectListClose,
    onMouseDown: handleListMouseDown,
    filterText: filterText.trim(),
    highlightedValue,
    noResultsMessage,
    listActionButton,
    listMaxHeight,
    onListAction: handleOnListAction,
    isLoading,
    onListScrollBottom,
    tableHeader,
    multiColumn,
    loaderDataRole: "filterable-select-list-loader",
    listPlacement,
    flipEnabled,
    isOpen,
    enableVirtualScroll,
    virtualScrollOverscan
  };
  const selectList = disableDefaultFiltering ? /*#__PURE__*/_react.default.createElement(_selectList.default, selectListProps, children) : /*#__PURE__*/_react.default.createElement(FilterableSelectList, selectListProps, children);
  const marginProps = (0, _useFormSpacing.default)(textboxProps);
  return /*#__PURE__*/_react.default.createElement(_select.default, _extends({
    hasTextCursor: true,
    readOnly: readOnly,
    disabled: disabled,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    isOpen: isOpen
  }, marginProps), /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/_react.default.createElement(_selectTextbox.default, _extends({
    activeDescendantId: activeDescendantId,
    ariaLabel: ariaLabel,
    ariaLabelledby: ariaLabelledby,
    labelId: label ? labelId : undefined,
    "aria-controls": selectListId.current,
    isOpen: isOpen,
    hasTextCursor: true,
    textboxRef: textboxRef
  }, getTextboxProps()))), selectList);
});
if (process.env.NODE_ENV !== "production") {
  FilterableSelect.propTypes = {
    "about": _propTypes.default.string,
    "accept": _propTypes.default.string,
    "accessibilityLabelId": _propTypes.default.string,
    "accessKey": _propTypes.default.string,
    "adaptiveLabelBreakpoint": _propTypes.default.number,
    "align": _propTypes.default.oneOf(["left", "right"]),
    "alt": _propTypes.default.string,
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "ariaDescribedBy": _propTypes.default.string,
    "ariaLabel": _propTypes.default.string,
    "ariaLabelledby": _propTypes.default.string,
    "as": _propTypes.default.elementType,
    "autoCapitalize": _propTypes.default.string,
    "autoComplete": _propTypes.default.string,
    "autoCorrect": _propTypes.default.string,
    "autoFocus": _propTypes.default.bool,
    "autoSave": _propTypes.default.string,
    "capture": _propTypes.default.oneOfType([_propTypes.default.oneOf(["environment", "user"]), _propTypes.default.bool]),
    "checked": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "color": _propTypes.default.string,
    "content": _propTypes.default.string,
    "contentEditable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "inherit", "true"]), _propTypes.default.bool]),
    "contextMenu": _propTypes.default.string,
    "dangerouslySetInnerHTML": _propTypes.default.shape({
      "__html": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]).isRequired
    }),
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "datatype": _propTypes.default.string,
    "defaultChecked": _propTypes.default.bool,
    "defaultValue": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
    "deferTimeout": _propTypes.default.number,
    "dir": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "disableDefaultFiltering": _propTypes.default.bool,
    "draggable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "enableVirtualScroll": _propTypes.default.bool,
    "enterKeyHint": _propTypes.default.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "fieldHelp": _propTypes.default.node,
    "flipEnabled": _propTypes.default.bool,
    "form": _propTypes.default.string,
    "formAction": _propTypes.default.string,
    "formattedValue": _propTypes.default.string,
    "formEncType": _propTypes.default.string,
    "formMethod": _propTypes.default.string,
    "formNoValidate": _propTypes.default.bool,
    "formTarget": _propTypes.default.string,
    "height": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "helpAriaLabel": _propTypes.default.string,
    "hidden": _propTypes.default.bool,
    "iconOnClick": _propTypes.default.func,
    "iconOnMouseDown": _propTypes.default.func,
    "iconTabIndex": _propTypes.default.number,
    "id": _propTypes.default.string,
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "inlist": _propTypes.default.any,
    "inputHint": _propTypes.default.string,
    "inputIcon": _propTypes.default.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": _propTypes.default.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": _propTypes.default.number,
    "is": _propTypes.default.string,
    "isLoading": _propTypes.default.bool,
    "isOptional": _propTypes.default.bool,
    "itemID": _propTypes.default.string,
    "itemProp": _propTypes.default.string,
    "itemRef": _propTypes.default.string,
    "itemScope": _propTypes.default.bool,
    "itemType": _propTypes.default.string,
    "label": _propTypes.default.string,
    "labelAlign": _propTypes.default.oneOf(["left", "right"]),
    "labelHelp": _propTypes.default.node,
    "labelId": _propTypes.default.string,
    "labelInline": _propTypes.default.bool,
    "labelSpacing": _propTypes.default.oneOf([1, 2]),
    "labelWidth": _propTypes.default.number,
    "lang": _propTypes.default.string,
    "leftChildren": _propTypes.default.node,
    "list": _propTypes.default.string,
    "listActionButton": _propTypes.default.oneOfType([_propTypes.default.element, _propTypes.default.bool]),
    "listMaxHeight": _propTypes.default.number,
    "listPlacement": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "max": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "maxLength": _propTypes.default.number,
    "maxWidth": _propTypes.default.string,
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "min": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "minLength": _propTypes.default.number,
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "multiColumn": _propTypes.default.bool,
    "multiple": _propTypes.default.bool,
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "nonce": _propTypes.default.string,
    "noResultsMessage": _propTypes.default.string,
    "onAbort": _propTypes.default.func,
    "onAbortCapture": _propTypes.default.func,
    "onAnimationEnd": _propTypes.default.func,
    "onAnimationEndCapture": _propTypes.default.func,
    "onAnimationIteration": _propTypes.default.func,
    "onAnimationIterationCapture": _propTypes.default.func,
    "onAnimationStart": _propTypes.default.func,
    "onAnimationStartCapture": _propTypes.default.func,
    "onAuxClick": _propTypes.default.func,
    "onAuxClickCapture": _propTypes.default.func,
    "onBeforeInput": _propTypes.default.func,
    "onBeforeInputCapture": _propTypes.default.func,
    "onBlur": _propTypes.default.func,
    "onBlurCapture": _propTypes.default.func,
    "onCanPlay": _propTypes.default.func,
    "onCanPlayCapture": _propTypes.default.func,
    "onCanPlayThrough": _propTypes.default.func,
    "onCanPlayThroughCapture": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onChangeCapture": _propTypes.default.func,
    "onChangeDeferred": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "onClickCapture": _propTypes.default.func,
    "onCompositionEnd": _propTypes.default.func,
    "onCompositionEndCapture": _propTypes.default.func,
    "onCompositionStart": _propTypes.default.func,
    "onCompositionStartCapture": _propTypes.default.func,
    "onCompositionUpdate": _propTypes.default.func,
    "onCompositionUpdateCapture": _propTypes.default.func,
    "onContextMenu": _propTypes.default.func,
    "onContextMenuCapture": _propTypes.default.func,
    "onCopy": _propTypes.default.func,
    "onCopyCapture": _propTypes.default.func,
    "onCut": _propTypes.default.func,
    "onCutCapture": _propTypes.default.func,
    "onDoubleClick": _propTypes.default.func,
    "onDoubleClickCapture": _propTypes.default.func,
    "onDrag": _propTypes.default.func,
    "onDragCapture": _propTypes.default.func,
    "onDragEnd": _propTypes.default.func,
    "onDragEndCapture": _propTypes.default.func,
    "onDragEnter": _propTypes.default.func,
    "onDragEnterCapture": _propTypes.default.func,
    "onDragExit": _propTypes.default.func,
    "onDragExitCapture": _propTypes.default.func,
    "onDragLeave": _propTypes.default.func,
    "onDragLeaveCapture": _propTypes.default.func,
    "onDragOver": _propTypes.default.func,
    "onDragOverCapture": _propTypes.default.func,
    "onDragStart": _propTypes.default.func,
    "onDragStartCapture": _propTypes.default.func,
    "onDrop": _propTypes.default.func,
    "onDropCapture": _propTypes.default.func,
    "onDurationChange": _propTypes.default.func,
    "onDurationChangeCapture": _propTypes.default.func,
    "onEmptied": _propTypes.default.func,
    "onEmptiedCapture": _propTypes.default.func,
    "onEncrypted": _propTypes.default.func,
    "onEncryptedCapture": _propTypes.default.func,
    "onEnded": _propTypes.default.func,
    "onEndedCapture": _propTypes.default.func,
    "onError": _propTypes.default.func,
    "onErrorCapture": _propTypes.default.func,
    "onFilterChange": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onFocusCapture": _propTypes.default.func,
    "onGotPointerCapture": _propTypes.default.func,
    "onGotPointerCaptureCapture": _propTypes.default.func,
    "onInput": _propTypes.default.func,
    "onInputCapture": _propTypes.default.func,
    "onInvalid": _propTypes.default.func,
    "onInvalidCapture": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onKeyDownCapture": _propTypes.default.func,
    "onKeyPress": _propTypes.default.func,
    "onKeyPressCapture": _propTypes.default.func,
    "onKeyUp": _propTypes.default.func,
    "onKeyUpCapture": _propTypes.default.func,
    "onListAction": _propTypes.default.func,
    "onListScrollBottom": _propTypes.default.func,
    "onLoad": _propTypes.default.func,
    "onLoadCapture": _propTypes.default.func,
    "onLoadedData": _propTypes.default.func,
    "onLoadedDataCapture": _propTypes.default.func,
    "onLoadedMetadata": _propTypes.default.func,
    "onLoadedMetadataCapture": _propTypes.default.func,
    "onLoadStart": _propTypes.default.func,
    "onLoadStartCapture": _propTypes.default.func,
    "onLostPointerCapture": _propTypes.default.func,
    "onLostPointerCaptureCapture": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "onMouseDownCapture": _propTypes.default.func,
    "onMouseEnter": _propTypes.default.func,
    "onMouseLeave": _propTypes.default.func,
    "onMouseMove": _propTypes.default.func,
    "onMouseMoveCapture": _propTypes.default.func,
    "onMouseOut": _propTypes.default.func,
    "onMouseOutCapture": _propTypes.default.func,
    "onMouseOver": _propTypes.default.func,
    "onMouseOverCapture": _propTypes.default.func,
    "onMouseUp": _propTypes.default.func,
    "onMouseUpCapture": _propTypes.default.func,
    "onOpen": _propTypes.default.func,
    "onPaste": _propTypes.default.func,
    "onPasteCapture": _propTypes.default.func,
    "onPause": _propTypes.default.func,
    "onPauseCapture": _propTypes.default.func,
    "onPlay": _propTypes.default.func,
    "onPlayCapture": _propTypes.default.func,
    "onPlaying": _propTypes.default.func,
    "onPlayingCapture": _propTypes.default.func,
    "onPointerCancel": _propTypes.default.func,
    "onPointerCancelCapture": _propTypes.default.func,
    "onPointerDown": _propTypes.default.func,
    "onPointerDownCapture": _propTypes.default.func,
    "onPointerEnter": _propTypes.default.func,
    "onPointerEnterCapture": _propTypes.default.func,
    "onPointerLeave": _propTypes.default.func,
    "onPointerLeaveCapture": _propTypes.default.func,
    "onPointerMove": _propTypes.default.func,
    "onPointerMoveCapture": _propTypes.default.func,
    "onPointerOut": _propTypes.default.func,
    "onPointerOutCapture": _propTypes.default.func,
    "onPointerOver": _propTypes.default.func,
    "onPointerOverCapture": _propTypes.default.func,
    "onPointerUp": _propTypes.default.func,
    "onPointerUpCapture": _propTypes.default.func,
    "onProgress": _propTypes.default.func,
    "onProgressCapture": _propTypes.default.func,
    "onRateChange": _propTypes.default.func,
    "onRateChangeCapture": _propTypes.default.func,
    "onReset": _propTypes.default.func,
    "onResetCapture": _propTypes.default.func,
    "onScroll": _propTypes.default.func,
    "onScrollCapture": _propTypes.default.func,
    "onSeeked": _propTypes.default.func,
    "onSeekedCapture": _propTypes.default.func,
    "onSeeking": _propTypes.default.func,
    "onSeekingCapture": _propTypes.default.func,
    "onSelect": _propTypes.default.func,
    "onSelectCapture": _propTypes.default.func,
    "onStalled": _propTypes.default.func,
    "onStalledCapture": _propTypes.default.func,
    "onSubmit": _propTypes.default.func,
    "onSubmitCapture": _propTypes.default.func,
    "onSuspend": _propTypes.default.func,
    "onSuspendCapture": _propTypes.default.func,
    "onTimeUpdate": _propTypes.default.func,
    "onTimeUpdateCapture": _propTypes.default.func,
    "onTouchCancel": _propTypes.default.func,
    "onTouchCancelCapture": _propTypes.default.func,
    "onTouchEnd": _propTypes.default.func,
    "onTouchEndCapture": _propTypes.default.func,
    "onTouchMove": _propTypes.default.func,
    "onTouchMoveCapture": _propTypes.default.func,
    "onTouchStart": _propTypes.default.func,
    "onTouchStartCapture": _propTypes.default.func,
    "onTransitionEnd": _propTypes.default.func,
    "onTransitionEndCapture": _propTypes.default.func,
    "onVolumeChange": _propTypes.default.func,
    "onVolumeChangeCapture": _propTypes.default.func,
    "onWaiting": _propTypes.default.func,
    "onWaitingCapture": _propTypes.default.func,
    "onWheel": _propTypes.default.func,
    "onWheelCapture": _propTypes.default.func,
    "openOnFocus": _propTypes.default.bool,
    "pattern": _propTypes.default.string,
    "placeholder": _propTypes.default.string,
    "prefix": _propTypes.default.string,
    "property": _propTypes.default.string,
    "radioGroup": _propTypes.default.string,
    "readOnly": _propTypes.default.bool,
    "rel": _propTypes.default.string,
    "required": _propTypes.default.bool,
    "resource": _propTypes.default.string,
    "results": _propTypes.default.number,
    "rev": _propTypes.default.string,
    "reverse": _propTypes.default.bool,
    "role": _propTypes.default.oneOfType([_propTypes.default.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "security": _propTypes.default.string,
    "size": _propTypes.default.oneOf(["large", "medium", "small"]),
    "slot": _propTypes.default.string,
    "spellCheck": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "src": _propTypes.default.string,
    "step": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "style": _propTypes.default.object,
    "suppressContentEditableWarning": _propTypes.default.bool,
    "suppressHydrationWarning": _propTypes.default.bool,
    "tabIndex": _propTypes.default.number,
    "tableHeader": _propTypes.default.node,
    "title": _propTypes.default.string,
    "tooltipPosition": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "translate": _propTypes.default.oneOf(["no", "yes"]),
    "typeof": _propTypes.default.string,
    "unselectable": _propTypes.default.oneOf(["off", "on"]),
    "validationIconId": _propTypes.default.string,
    "validationOnLabel": _propTypes.default.bool,
    "value": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
    "virtualScrollOverscan": _propTypes.default.number,
    "vocab": _propTypes.default.string,
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "width": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  };
}
var _default = exports.default = FilterableSelect;