"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledSelectTextChildrenWrapper = exports.StyledSelectText = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _inputSizes = _interopRequireDefault(require("../../../../__internal__/input/input-sizes.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSelectText = exports.StyledSelectText = _styledComponents.default.span`
  ${({
  disabled,
  hasPlaceholder,
  readOnly,
  transparent,
  size
}) => (0, _styledComponents.css)`
    align-items: center;
    display: inline-flex;
    flex-grow: 1;
    font-size: 14px;
    height: auto;
    outline: none;
    width: 30px;
    z-index: 1;
    padding-left: ${_inputSizes.default[size].horizontalPadding};

    ${transparent && (0, _styledComponents.css)`
      font-weight: 900;
      text-align: right;
      flex-direction: row-reverse;
    `}

    ${hasPlaceholder && (0, _styledComponents.css)`
      color: var(--colorsUtilityYin055);
      font-weight: normal;
      user-select: none;
    `}

    ${disabled && (0, _styledComponents.css)`
      cursor: not-allowed;
      color: var(--colorsUtilityYin030);
      text-shadow: none;
    `}

    ${readOnly && (0, _styledComponents.css)`
      cursor: default;
      color: var(--colorsUtilityYin065);
      text-shadow: none;
    `}
  `}
`;
const StyledSelectTextChildrenWrapper = exports.StyledSelectTextChildrenWrapper = _styledComponents.default.span`
  display: block;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;