"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _selectText = require("./select-text.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const SelectText = ({
  disabled,
  formattedValue = "",
  onClick,
  onMouseDown,
  placeholder,
  readOnly,
  transparent,
  size = "medium"
}) => {
  const hasPlaceholder = !disabled && !readOnly && !formattedValue;
  return /*#__PURE__*/_react.default.createElement(_selectText.StyledSelectText, {
    "aria-hidden": true,
    "data-element": "select-text",
    disabled: disabled,
    hasPlaceholder: hasPlaceholder,
    onClick: onClick,
    onMouseDown: onMouseDown,
    readOnly: readOnly,
    transparent: transparent,
    size: size
  }, /*#__PURE__*/_react.default.createElement(_selectText.StyledSelectTextChildrenWrapper, null, hasPlaceholder ? placeholder : formattedValue));
};
var _default = exports.default = SelectText;