"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledSystem = require("styled-system");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _inputIconToggle = _interopRequireDefault(require("../../__internal__/input-icon-toggle/input-icon-toggle.style"));
var _inputPresentation = _interopRequireDefault(require("../../__internal__/input/input-presentation.style"));
var _input = _interopRequireDefault(require("../../__internal__/input/input.style"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _themes = require("../../style/themes");
var _formField = _interopRequireDefault(require("../../__internal__/form-field/form-field.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledSearch = _styledComponents.default.div`
  ${({
  isFocused,
  searchWidth,
  maxWidth,
  searchHasValue,
  showSearchButton,
  theme,
  variant
}) => {
  const darkVariant = variant === "dark";
  const variantColor = darkVariant ? "var(--colorsUtilityYang080)" : "var(--colorsUtilityMajor300)";
  return (0, _styledComponents.css)`
      ${_styledSystem.margin}
      width: ${searchWidth ? `${searchWidth}` : "100%"};
      max-width: ${maxWidth ? `${maxWidth}` : "100%"};
      padding-bottom: var(--spacing025);
      background-color: transparent;
      display: inline-flex;
      font-size: var(--fontSize100);
      font-weight: 700;

      ${!showSearchButton && (0, _styledComponents.css)`
        border-bottom: var(--spacing025) solid ${variantColor};

        :hover {
          border-bottom-color: ${darkVariant ? "var(--colorsUtilityYang100)" : "var(--colorsUtilityMajor400)"};
          cursor: pointer;
        }

        ${(searchHasValue || isFocused) && (0, _styledComponents.css)`
          border-bottom-color: transparent;

          :hover {
            border-bottom-color: transparent;
            cursor: default;
          }
        `}
      `}

      ${_input.default} {
        ::-moz-placeholder {
          color: var(--colorsUtilityYin055);
          opacity: 1;
        }
        ::placeholder {
          color: var(--colorsUtilityYin055);
        }

        ${darkVariant && (0, _styledComponents.css)`
          ::-moz-placeholder {
            color: var(--colorsUtilityYang080);
            opacity: 1;
          }
          ::placeholder {
            color: var(--colorsUtilityYang080);
          }
        `}

        ${darkVariant && searchHasValue && !showSearchButton && (0, _styledComponents.css)`
          color: var(--colorsUtilityYang100);
        `}
      }

      ${_inputPresentation.default} {
        [data-element="search"] {
          height: auto;

          ${!darkVariant && (0, _styledComponents.css)`
            color: var(--colorsUtilityYin065);

            :hover {
              color: var(--colorsUtilityYin100);
            }
          `}

          ${darkVariant && (0, _styledComponents.css)`
            color: var(--colorsUtilityYang080);

            :hover {
              color: var(--colorsUtilityYang100);
            }
          `}
        }

        ${darkVariant && !showSearchButton && (0, _styledComponents.css)`
          background-color: transparent;
          border-color: var(--colorsUtilityYang080);
        `}

        ${!darkVariant && (0, _styledComponents.css)`
          background-color: ${searchHasValue || isFocused || showSearchButton ? "var(--colorsUtilityYang100)" : "transparent"};
        `}

        ${showSearchButton && (0, _styledComponents.css)`
          border-top-right-radius: var(--borderRadius000);
          border-bottom-right-radius: var(--borderRadius000);
        `}

        flex: 1;
        font-size: var(--fontSize100);
        font-weight: 700;
        padding-bottom: var(--spacing025);
        padding-top: 1px;
        cursor: pointer;

        ${!isFocused && !searchHasValue && !showSearchButton && (0, _styledComponents.css)`
          border: 1px solid transparent;
        `}

        ${!isFocused && searchHasValue && !showSearchButton && (0, _styledComponents.css)`
          background-color: ${darkVariant ? "transparent" : "var(--colorsUtilityYang100)"};
        `}
      }

      ${_formField.default} {
        flex: 1;
        z-index: ${theme.zIndex.smallOverlay};
      }

      ${_icon.default} {
        :not([data-element="search"]) {
          ${darkVariant && !showSearchButton && (0, _styledComponents.css)`
            color: var(--colorsUtilityYang080);

            :hover {
              color: var(--colorsUtilityYang100);
            }
          `}

          ${!darkVariant && (0, _styledComponents.css)`
            color: var(--colorsActionMinor500);

            :hover {
              color: var(--colorsActionMinor600);
            }
          `}
        }
        cursor: pointer;
      }

      ${_inputIconToggle.default} {
        ${searchHasValue && (0, _styledComponents.css)`
          margin-bottom: -1px;
        `}
      }
    `;
}}
`;
StyledSearch.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledSearch;