"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Search = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _utils = require("../../style/utils");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _search = _interopRequireDefault(require("./search.style"));
var _searchButton = _interopRequireDefault(require("./search-button.style"));
var _icon = _interopRequireDefault(require("../icon"));
var _textbox = _interopRequireDefault(require("../textbox"));
var _button = _interopRequireDefault(require("../button"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
const Search = exports.Search = /*#__PURE__*/_react.default.forwardRef(({
  defaultValue,
  onChange,
  onClick,
  onFocus,
  onBlur,
  onKeyDown,
  value,
  id,
  name,
  searchWidth,
  maxWidth,
  searchButton,
  searchButtonAriaLabel = "search button",
  placeholder,
  variant = "default",
  "aria-label": ariaLabel = "search",
  tabIndex,
  error,
  warning,
  info,
  tooltipPosition,
  ...rest
}, ref) => {
  const isControlled = value !== undefined;
  const initialValue = isControlled ? value : defaultValue;
  const locale = (0, _useLocale.default)();
  const searchRef = (0, _react.useRef)(null);
  const inputRef = (0, _react.useRef)(null);
  (0, _react.useImperativeHandle)(ref, () => ({
    focus() {
      inputRef.current?.focus();
    }
  }), []);
  if (!deprecateUncontrolledWarnTriggered && !isControlled) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Search` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  !(typeof initialValue === "string") ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, "This component has no initial value") : (0, _invariant.default)(false) : void 0;
  const [searchValue, setSearchValue] = (0, _react.useState)(initialValue);
  const [isFocused, setIsFocused] = (0, _react.useState)(false);
  const isSearchValueEmpty = !isControlled ? searchValue.length === 0 : value.length === 0;
  let buttonProps = {};
  const handleChange = event => {
    if (onChange) {
      onChange(event);
    }
    if (!isControlled) {
      setSearchValue(event.target.value);
    }
  };
  const handleFocus = event => {
    setIsFocused(true);
    if (onFocus) {
      onFocus(event);
    }
  };
  if (searchButton && onClick) {
    buttonProps = {
      onClick: () => {
        onClick({
          target: {
            name,
            id,
            value: !isControlled ? searchValue : value
          }
        });
      }
    };
  }
  const handleIconClick = () => {
    setSearchValue("");
    if (onChange) {
      onChange({
        target: {
          ...(name && {
            name
          }),
          ...(id && {
            id
          }),
          value: ""
        }
      });
    }
    inputRef.current?.focus();
  };
  const handleMouseDown = event => {
    event.preventDefault();
  };
  const handleBlur = event => {
    setIsFocused(false);

    /* istanbul ignore else */
    if (onBlur) {
      onBlur(event);
    }
  };
  const handleKeyDown = event => {
    if (event.key.length === 1) {
      event.stopPropagation();
    }
    if (onKeyDown) {
      onKeyDown(event);
    }
  };
  const searchButtonText = typeof searchButton === "string" ? searchButton : locale.search.searchButtonText();
  const searchHasValue = !isControlled ? !!searchValue?.length : !!value?.length;
  return /*#__PURE__*/_react.default.createElement(_search.default, _extends({
    ref: searchRef,
    isFocused: isFocused,
    searchWidth: searchWidth,
    maxWidth: maxWidth,
    searchHasValue: searchHasValue,
    showSearchButton: !!searchButton,
    variant: variant,
    mb: 0
  }, (0, _utils.filterStyledSystemMarginProps)(rest), (0, _tags.default)("search", rest), {
    id: id,
    name: name
  }, rest), /*#__PURE__*/_react.default.createElement(_textbox.default, {
    placeholder: placeholder,
    value: !isControlled ? searchValue : value,
    inputIcon: !isSearchValueEmpty ? "cross" : undefined,
    iconTabIndex: !isSearchValueEmpty ? 0 : -1,
    iconOnClick: handleIconClick,
    iconOnMouseDown: handleMouseDown,
    "aria-label": ariaLabel,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onChange: handleChange,
    onKeyDown: handleKeyDown,
    ref: inputRef,
    tabIndex: tabIndex,
    error: error,
    warning: warning,
    info: info,
    leftChildren: !searchButton ? /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "search",
      ml: 1
    }) : undefined,
    tooltipPosition: tooltipPosition
  }), searchButton && /*#__PURE__*/_react.default.createElement(_searchButton.default, null, /*#__PURE__*/_react.default.createElement(_button.default, _extends({
    "aria-label": searchButtonAriaLabel,
    size: "medium",
    px: 2,
    buttonType: "primary",
    iconPosition: "before",
    iconType: "search",
    className: "search-button"
  }, buttonProps), searchButtonText)));
});
if (process.env.NODE_ENV !== "production") {
  Search.propTypes = {
    "aria-label": _propTypes.default.string,
    "children": _propTypes.default.node,
    "defaultValue": _propTypes.default.string,
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "id": _propTypes.default.string,
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "maxWidth": _propTypes.default.string,
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "onBlur": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "placeholder": _propTypes.default.string,
    "searchButton": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "searchButtonAriaLabel": _propTypes.default.string,
    "searchWidth": _propTypes.default.string,
    "tabIndex": _propTypes.default.number,
    "tooltipPosition": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "value": _propTypes.default.string,
    "variant": _propTypes.default.oneOf(["dark", "default"]),
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool])
  };
}
Search.displayName = "Search";
var _default = exports.default = Search;