import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../__internal__/validations";
export interface SearchEvent {
    target: {
        name?: string;
        id?: string;
        value: string;
    };
}
export interface SearchProps extends ValidationProps, MarginProps {
    /** Prop to specify the aria-label of the search component */
    "aria-label"?: string;
    /** Prop to specify the aria-label of the search button */
    searchButtonAriaLabel?: string;
    /** Prop for `uncontrolled` use */
    defaultValue?: string;
    /** Prop for `id` */
    id?: string;
    /** Prop for `name` */
    name?: string;
    /** Prop for `onBlur` events */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Prop for `onChange` events */
    onChange?: (ev: SearchEvent) => void;
    /** Prop for `onClick` events.
     *  `onClick` events are triggered when the `searchButton` is clicked
     */
    onClick?: (ev: SearchEvent) => void;
    /** Prop for `onFocus` events */
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Prop for `onKeyDown` events */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Prop for a placeholder */
    placeholder?: string;
    /**
     * Pass a boolean to render a search Button with default text.
     * Pass a string to override the text in the search Button
     * */
    searchButton?: boolean | string;
    /**
     * Prop for specifying an input width length.
     * Leaving the `searchWidth` prop with no value will default the width to '100%'
     */
    searchWidth?: string;
    /**
     * Prop for specifying the max-width of the input.
     * Leaving the `maxWidth` prop with no value will default the width to '100%'
     */
    maxWidth?: string;
    /** Prop for `controlled` use */
    value?: string;
    /** Prop to specify the styling of the search component */
    variant?: "default" | "dark";
    /** Input tabindex */
    tabIndex?: number;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
}
export declare type SearchHandle = {
    /** Programmatically focus on root container of Dialog. */
    focus: () => void;
} | null;
export declare const Search: React.ForwardRefExoticComponent<SearchProps & React.RefAttributes<SearchHandle>>;
export default Search;
